/*
 * XMLElement.java
 *
 * Created on 2 gennaio 2004, 16.32
 */

package Src.Servizi.ServiziXML.LibreriaDOM;

/**
 *
 * @author  Monaco Luca
 * @version 1
 */
import java.io.*;
import org.xml.sax.SAXException;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import Src.Servizi.Exception.*;

/**L'interfaccia deve essere implementata dagli Oggetti che ottengono persistenza attraverso
 * file XML.Propone l'implementazione di due metodi per la trasformazione di un element in un
 * oggetto e viceversa.*/
public interface XMLElement {
    
    /**Per la trasformazione di un oggetto in un elemento XML*/
    public Element objToXml(Document doc);
    
    /**Per la trasformazione di un element in un oggetto*/
    public XMLElement xmlToObj(Element el)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException;
    
}

