/*
 * LibreriaDOM.java
 *
 * Created on 30 dicembre 2003, 14.58
 */

package Src.Servizi.ServiziXML.LibreriaDOM;

/**
 *
 * @author  Monaco Luca
 * @version 1
 */
import org.w3c.dom.*;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;


public class LibreriaDOM {

    /** Creates new LibreriaDOM */
    public LibreriaDOM() {
    }
    
    
    /**Il metodo permette di creare avere una rappresentazione a oggetti del file XML.
     *@return Un istanza Document contenente la struttura del file XML, ottenuta mediante parsing dello stesso file.*/
    public static Document loadDocument(String nomeFile)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        File f = new File(nomeFile);
        DocumentBuilderFactory dbf= DocumentBuilderFactory.newInstance();
        DocumentBuilder db= dbf.newDocumentBuilder();
        Document doc= db.parse(f);
        return doc;
    }
    
    
    /** Dato un documento XML e il nome del tag restituisce l'Element nella posizione indicata da index.
     *@param doc Il documento XML.
     *@param tagName Il nome del tag.
     *@param index La sua posizione.*/
    public static Element getElement(Document doc, String tagName, int index)
    {
        NodeList list = doc.getDocumentElement().getElementsByTagName(tagName);
        return (Element) list.item(index);
    }
    
    
    /**Dato un documento XML e il nome di un tag restituisce un intero che indica il numero di volte che il
     *tag compare all'interno del documento.
     *@param doc L'istanza Document rappresentante il file XML.
     *@param tagName Il nome del tag.
     *@return Il numero di volte che il tag compare nel Document.*/
    public static int getSize(Document doc,String tagName)
    {
        NodeList list = doc.getDocumentElement().getElementsByTagName(tagName);        
        return list.getLength();
    }
    
    
    /**Recupera il nome del tag radice di un documento XML.*/
    public static String getRootName(Document doc)
    {
        return doc.getDocumentElement().getTagName();
    }
    
    
    /**Dato un elemento restituisce il valore dell'elemento flglio dal nome specifcato.
     *@param e Elemento padre.
     *@param tagName Nome dell'elemento figlio.
     *@return Valore dell'elemento figlio.*/
    public static String getValue(Element e, String tagName)
    {
        NodeList elements = e.getElementsByTagName(tagName);    //Sotto-nodi di "e" che hanno il tag "tagName"
        Node node = elements.item(0);                           //Il primo nodo della lista
        NodeList nodes = node.getChildNodes();                  //La lista dei suoi nodi figli
        for(int i=0; i<nodes.getLength();i++){                  
            String s = ((Node) nodes.item(i)).getNodeValue().trim();
            if (s.equals(" ") || s.equals("\r")){
                continue;
            }
            else return s;
            
        }
        return null;
    }
    
    
    /**Datp un elemento restituisce il suo valore*/
    public static String getValue(Element e)
    {
        Node node = (Node)e;                           
        NodeList nodes = node.getChildNodes();                  
        for(int i=0; i<nodes.getLength();i++){                  
            String s = ((Node) nodes.item(i)).getNodeValue().trim();
            if (s.equals(" ") || s.equals("\r")){
                continue;
            }
            else return s;
            
        }
        return null;
    }
    
    /**Dato un elemento restituisce il valore dell'elemento flglio dal nome specifcato nella posizione indicata.
     *@param e Elemento padre.
     *@param tagName Nome dell'elemento figlio.
     *@return Valore dell'elemento figlio.*/
    public static String getValue(Element e, String tagName,int index)
    {
        NodeList elements = e.getElementsByTagName(tagName);    //Sotto-nodi di "e" che hanno il tag "tagName"
        Node node = elements.item(index);                           //Il primo nodo della lista
        NodeList nodes = node.getChildNodes();                  //La lista dei suoi nodi figli
        for(int i=0; i<nodes.getLength();i++){                  
            String s = ((Node) nodes.item(i)).getNodeValue().trim();
            if (s.equals(" ") || s.equals("\r")){
                continue;
            }
            else return s;
            
        }
        return null;
    }
    
    
    /**Il metodo permette di creare un elemento di testo tipo: <nameElement> text </nameElement>
     * L'elemento creato viene aggiunto in coda al Document passato solo se il flag "append"  settato
     *@param doc Istanza Document attrverso cui viene creato l'elemento el alla quale viene eventualmente aggiunto.
     *@param nameElement Nome del tag che si vuol creare.
     *@param text Contenuto del tag.
     *@param append Flag che settato permentte di aggiungere l'elemento al Document*/
    public static Element createTextElement(Document doc,String nameElement,String text,boolean append)
    {
        Element elem = doc.createElement(nameElement);
        Text testo = doc.createTextNode(text);
        elem.appendChild(testo);
        if(append) doc.appendChild(elem);
        return elem;
    }
    
    
    /**Il metodo permette di creare un elemento di testo tipo: <nameElement nameAttr="valueAttr"> text </nameElement>
     *
     *@param doc Istanza Document attrverso cui viene creato l'elemento el alla quale viene eventualmente aggiunto.
     *@param nameElement Nome del tag che si vuol creare.
     *@param text Contenuto del tag.
     *@param nameAttr nome dell'attributo.
     *@param valueAttr Valore settato nell'attributo.*/
    public static Element createTextElementWithAttribute(Document doc,String nameElement,String text,String nomeAttr,String valueAttr)
    {
        Element elem = doc.createElement(nameElement);
        elem.setAttribute(nomeAttr,valueAttr);
        Text testo = doc.createTextNode(text);
        elem.appendChild(testo);
        return elem;
    }

}
