/*
 * DocumentHandler.java
 *
 * Created on 2 gennaio 2004, 15.39
 */

package Src.Servizi.ServiziXML.LibreriaDOM;

/**
 *
 * @author  Monaco Luca
 * @version 1
 */
import org.w3c.dom.*;
import java.io.*;
import org.xml.sax.*;
import javax.xml.parsers.*;
import org.apache.xml.serialize.*;
import Src.Logica.*;
import Src.Servizi.Exception.*;

/**La classe rappresenta un entit che si occupa di mediare tra Applicazione DOM (colui che vuole
 *sfruttare le funzionalit di DOM) e le fuzioni DOM stesse.*/
public class DocumentHandler implements DOMHandler
{

    /**Nome del file XML di cui  gestore l'oggetto DocumentHandler*/
    String nomeFile;
    
    /** Creates new DocumentHandler */
    public DocumentHandler(String nomeFile) {
        this.nomeFile=nomeFile;
    }
    
    
    /**Implementazione dell'omonimo metodo dell'interfaccia DOMApplication. Permette di cercare su
     * un file XML un determinato elemento con un certo tagName individuato attraverso il valore di un 
     * suo nodo di testo di nome attrName e di creare quindi un apposito oggetto che lo modella.
     *
     *@param tagName - Nome del tag da cercare.
     *@param attrName - Nome del sotto nodo di testo da cercare all'interno di tagName.
     *@param value - Valore che tale attributo deve avere.*/
     
    public XMLElement loadElementFromXML(String tagName,String attrName,String value)
    throws FileNotFoundException, IOException, ParserConfigurationException, SAXException,ElementNotFoundException
    {
        //String nomeFile="c:/Documenti/Universit/II anno LS/Ingengeria del SW/ProgettoVendite/Shoplist.xml";
        Document doc = LibreriaDOM.loadDocument(this.nomeFile);
        int nClienti = LibreriaDOM.getSize(doc,tagName);
        XMLElement obj=null;
        
        for(int i=0;i<nClienti;i++){
            Element el = LibreriaDOM.getElement(doc,tagName,i);
            String ris= LibreriaDOM.getValue(el,attrName);
            
            if(ris.equals(value)){
                obj = this.createXMLElement(doc,el);
                break;
            }
            
        }
        return obj;
        
    }
    
    public XMLElement createXMLElement(Document doc,Element el)
    throws FileNotFoundException, IOException, ParserConfigurationException, SAXException, ElementNotFoundException
    {
        String rootName = LibreriaDOM.getRootName(doc);
        if (rootName.equals("TrainingSet")) return new TrainingSet(el);
        throw new ElementNotFoundException("L'elemento richiesto non esiste.");
    }
    
    
    /**Il metodo permette l'aggiunta di un istanza Ordine all'interno di un file XML esistente.
     *@param obj L'oggetto che vogliamo salvare (deve implementare XMLElement).
     *@return L'oggetto Element salvato.*/
    public Element saveElementInXML(XMLElement obj,String tagName,String idName)
    throws FileNotFoundException,IOException,ParserConfigurationException,SAXException
    {
        
        Document doc = LibreriaDOM.loadDocument(this.nomeFile);
        
        //Recupero l'elemento radice della struttura XML
        Element radice = doc.getDocumentElement();
        
        //Rimuovo l'oggetto dal documento se esiste
        this.removeElementFromXML(doc,tagName,idName,obj);
        
        //Creo un element che rappresenti l'oggetto che voglio salvare
        Element elem = obj.objToXml(doc);
                
        //Aggiungo il nuovo elemento alla struttura
        radice.appendChild(elem);
        
        //Salvo la struttura
        XMLSerializer ser=new XMLSerializer();
        ser.setOutputCharStream(new FileWriter(nomeFile));
        ser.serialize(doc);
        
        return elem;
    }
    
    
    /**La funzione permette di eliminare l'Oggetto specificato dal file XML associato all'Handler
     *@param doc Document associato al file.
     *@param tagName Nome del tag associato alla classe da elimanare
     *@param idName Nome dell'attributo che permette l'identificazione dell'elemento nel file XML.*/
    public void removeElementFromXML(Document doc,String tagName,String idName, Object obj)
    throws FileNotFoundException,IOException,ParserConfigurationException,SAXException
    {/*
        int n = LibreriaDOM.getSize(doc,tagName);
        for(int i=0;i<n;i++){
            Element el = LibreriaDOM.getElement(doc,tagName,i);
            String nome = LibreriaDOM.getValue(el,idName);
            if(nome.equals(((Istanza)obj).getId())){
                doc.getDocumentElement().removeChild(el);
                break;
            }
        }
      */  
    }

}
