/*
 * DOMApplication.java
 *
 * Created on 30 dicembre 2003, 15.44
 */

package Src.Servizi.ServiziXML.LibreriaDOM;

/**
 *
 * @author  Monaco Luca
 * @version 1
 */

import java.io.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import javax.xml.parsers.*;
import Src.Servizi.Exception.*;

/**Tutte le classi che volgiono utilizzare l'interfaccia DOM devono implementare questa interfaccia,
 * in modo da offrire la possibilit si salvare e caricare un'istanza verso un file XML.*/
public interface DOMHandler {
    
    /**Il metodo permette di cercare e di creare un certo oggetto a partire da informazioni presenti in un file
     * XML.
     *@param nomeFile Il nome del file XML.
     *@param id Identificatore dell'elemento.*/
    public XMLElement loadElementFromXML(String tagName,String attrName,String value)
    throws FileNotFoundException,IOException,ParserConfigurationException,SAXException,ElementNotFoundException;
    
    
    /**Il metodo permette di aggiungere un elemento al file XML
     *@return L'oggetto Element salvato.*/
    public Element saveElementInXML(XMLElement obj,String tagName,String idName)
    throws FileNotFoundException,IOException,ParserConfigurationException,SAXException;
    

}

