/*
 * Timeout.java
 *
 * Created on 15 aprile 2004, 12.23
 */

package Src.Servizi.NetworkSupport;

/**
 *
 * @author  Monaco Luca
 */
import Src.Servizi.Exception.*;
import Src.LogicaDistribuito.*;

public class Timeout extends Thread
{
    /**Tempo dopo il quale viene lanciata l'eccezione*/
    protected int time;
    
    /**Tipo del messaggio a cui  associato il timeout.*/
    protected String tipo;
    
    protected NodoClassificatore nodo;
    
    /** Creates a new instance of Timeout */
    public Timeout(int t,NodoClassificatore n,String tipo) {
        this.time=t;
        this.tipo=tipo;
        this.nodo=n;
        start();
    }
    
    public int getTime()
    {
        return this.time;
    }

    public void setTime(int t)
    {
        this.time = t;
    }
    
    public void run()
    {
        try{
            sleep(this.time);
            throw new TimeoutException();
        }
        catch(InterruptedException e){
            System.out.println(e.getMessage());
        }
        catch(TimeoutException e){
            try{
                System.out.println("Nodo "+this.nodo.getPort()+": Timeout assocciato all'invio del messaggio "+this.tipo+" SCADUTO!");
                this.nodo.findWhoFailed(this.tipo);
            }
            catch(Exception er){
                System.out.println(er.getMessage());
            }
        }
    }
    
    public void restart()
    {
        new Timeout(this.time,this.nodo,this.tipo);
    }
    
    public void ferma()
    {
        stop();
    }
}
