/*
 * ServerManager.java
 *
 * Created on 7 aprile 2004, 9.22
 */

package Src.Servizi.NetworkSupport;

/**
 *
 * @author  Monaco Luca
 */
import java.io.*;
import java.net.*;
import javax.xml.parsers.*;
import org.xml.sax.SAXException;
import Src.Servizi.Exception.*;

public class ServerThread extends Thread implements Serializable{
    
    /**Porta sulla quale il server  in ascolto.*/
    protected int port;
    
    /**Nodo di rete associato al getsore.*/
    protected NetworkNode node;
    
    /**Connessione al nodo precedente.*/
    protected Socket connection;
    
       
    protected ObjectOutputStream out;
    protected ObjectInputStream in;
    
    
    /** Creates a new instance of ServerManager */
    public ServerThread(int port,NetworkNode node,Socket s) 
    throws IOException 
    {
        this.port = port;
        this.node = node;
        this.connection = s;
        
        this.out  = new ObjectOutputStream(this.connection.getOutputStream());
        this.in   = new ObjectInputStream(this.connection.getInputStream());
        
        start();
    }
    
    public void run()
    {
        try{
            //System.out.println("Connesssione avvenuta: PORTA SERVER: "+this.connection.getLocalPort()+"   PORTA CLIENTE: "+this.connection.getPort());
            this.waitForReceive();
        }
        catch(Exception e){
            System.out.println("ECCEZIONE Nodo "+node.getPort()+":ServerThread.run():"+e.getMessage());
        }
    }

    
    public void waitForReceive()
    throws IOException, InterruptedException, ClassNotFoundException
    {
        try{
        //this.node.sendString(this.receiveString(),"next");
        this.receiveMessage();
        this.waitForReceive();
        }
        catch(Exception e){}
    }
    
    
    public Socket getConnection(){
        return this.connection;
    }
    
    /**Permettere di ricevere un messaggio dal nodo precedente.*/
    public String receiveString()
    throws IOException, ClassNotFoundException
    {
        String ret = (String)this.in.readObject();
        System.out.println("Server "+this.node.getPort()+":  arrivato il msg: "+ret);
        return ret;
    }
    
    /**Permette di inviare un messaggio di risposta (tipo Ack) al nodo precedente*/
    public void sendString(String msg) 
    throws InterruptedException, IOException
    {
        this.sleep(100);
        System.out.println("Server "+this.node.getPort()+": Invio del msg:  "+msg);
        this.out.writeObject(new String(msg));
    }
    
    
    /**Permette di ricevere un qualunque messaggio*/
    public Message receiveMessage()
    throws IOException, ClassNotFoundException, InterruptedException, ParserConfigurationException, SAXException, AttributeNotFoundException
    {
        Message ret = (Message)this.in.readObject();
        //System.out.println("Server "+this.node.getPort()+":  arrivato il msg: "+ret);
        return ret;
    }
    
    
    /**Permette l'invio di un qualusiasi messaggio.*/
    public void sendMessage(Message msg)
    throws InterruptedException, IOException
    {
        this.sleep(100);
        System.out.println("Server "+this.node.getPort()+": Invio del msg:  "+msg+" verso "+this.connection.getPort());
        this.out.writeObject(msg);
    }
}
