/*
 * ServerManager.java
 *
 * Created on 7 aprile 2004, 9.22
 */

package Src.Servizi.NetworkSupport;

/**
 *
 * @author  Monaco Luca
 */
import java.io.*;
import java.net.*;


public class ServerManager extends Thread implements Serializable{
    
    /**Porta sulla quale il server  in ascolto.*/
    protected int port;
    
    /**Nodo di rete associato al gestore.*/
    protected NetworkNode node;
    
    /**Gestisce la richiesta conrrente.*/
    protected ServerThread st;
    
    protected ServerSocket server;
    
    
     public ServerManager() 
    {}
       
    public ServerManager(int port, NetworkNode node) 
    {
        this.port = port;
        this.node = node;
        //Utilizzo del Thread di base
        
        start();
        
    }
    
    public void run()
    {
        try{
            this.server = new ServerSocket(this.port);
            this.waitConnectionRequest();
        }
        catch(Exception e){
            System.out.println("ECCEZIONE Nodo "+this.node.getPort()+":ServerManager.run():"+e.getMessage());
        }   
    } 
    
    /**Il metoto mette in attesa il Server di una richiesta*/
    public void waitConnectionRequest()
    throws IOException, InterruptedException
    {
        while(true){
             Socket socket = this.server.accept();
             
             this.st = new ServerThread(this.port,this.node,socket);
             
        }
    }
    
    
    public Socket getConnection(){
        return this.st.getConnection();
    }
    
    
    public ServerThread getServerThread(){
        return this.st;
    }
    
    
    /**Permettere di ricevere un messaggio di tipo String dal nodo precedente.*/
    public String receiveString()
    throws IOException, ClassNotFoundException
    {
        return this.st.receiveString();
    }
    
    /**Permette di inviare un messaggio di risposta (tipo Ack) al nodo precedente*/
    public void sendString(String msg) 
    throws InterruptedException, IOException
    {
        this.st.sendString(msg);
    }
    
    
    /**Permettere di ricevere un messaggio dal nodo precedente.*/
    public Message receiveMessage()
    throws IOException, ClassNotFoundException
    {
        try{
            return this.st.receiveMessage();
        }
        catch(Exception e){
            System.out.println(e.getMessage());
        }
        return null;
    }
    
    public void sendMessage(Message msg)
    throws InterruptedException, IOException
    {
        this.st.sendMessage(msg);
    }
    
}    
    
    
    