/*
 * QueueManager.java
 *
 * Created on 9 aprile 2004, 12.11
 */

package Src.Servizi.NetworkSupport;

/**
 *
 * @author  Monaco Luca
 */
import java.util.*;
import java.io.*;

/**La classe rappresenta un processo gestore di una o pi code.*/
public abstract class QueueManager extends Thread implements Serializable{
    
   
    /** Creazione di un gestore di un unica coda. */
    public QueueManager()
    {
        start();
    }
    
    
    
    public void run()
    {
        try{
            this.suspendManager();
        }
        catch(InterruptedException e){
            System.out.println(e.getMessage());
        }
    }
    
    
    /**Permette la sospensione del Manager*/
    public void suspendManager()
    throws InterruptedException
    {
        suspend();
    }
    
    
    /**Attiva il Manager e permette di gestire la prima richiesta di ogni coda.*/
    public void resumeManager()
    throws InterruptedException
    {
        this.resume();
        this.manageRequests();
        //this.suspendManager();
    }
    
    
    public abstract void manageRequests();
    
    public abstract void manageRequestOn(Queue q);     
}
