/*
 * Queue.java
 *
 * Created on 9 aprile 2004, 11.48
 */

package Src.Servizi.NetworkSupport;

/**
 *
 * @author  Monaco Luca
 */
import java.util.*;
import java.io.*;

/**La classe rappresenta una coda di richieste*/
public class Queue implements Serializable{
    
    /**Lista in cui memorizzare le richieste.*/
    protected ArrayList requestList;
    
    /**Nome della coda.*/
    protected String name;
    
    /**Priorit associata alla coda.*/
    protected int priority;
    
    
    /***/
    public Queue(String nome)
    {
        new Queue(nome,0);
    }
    
    public Queue(String nome, int p)
    {
        this.name=nome;
        this.priority=p;
        this.requestList = new ArrayList();
    }
    
    
    public String getName()
    {
        return this.name;
    }
    
    public int getPriority()
    {
        return this.priority;
    }
    
    /**Prelievo della richiesta in coda in posizione pos.*/
    public Request getRequest(int pos)
    {
        return (Request)this.requestList.remove(pos); 
    }
    
    /**Prelievo della richiesta in test alla coda.*/
    public Request getFirstRequest()
    {
        return this.getRequest(0); 
    }
    
    /**Prelievo di una casuale richiesta in coda.*/
    public Request getCasualRequest()
    {
        Random r = new Random();
        int n= r.nextInt(this.requestList.size());
        return this.getRequest(n); 
    }
    
    /**Recupera il Numero delle richieste in coda*/
    public int getSize()
    {
        return this.requestList.size(); 
    }
    
    /**Introdizione di una richiesta r in coda.*/
    public void putInQueue(Request r)
    {
        this.requestList.add(r); 
    }
    
    
    public void reset()
    {
        this.requestList = new ArrayList(); 
    }
}
