/*
 * OffLineMessage.java
 *
 * Created on 14 aprile 2004, 18.00
 */

package Src.Servizi.NetworkSupport;

/**
 *
 * @author  Monaco Luca
 */
import java.net.*;

public class OffLineMessage extends Message {
    
    /**Indirizzo del nodo che esce dalla rete.*/
    Address node;
    
    /**Se settato il nodo che ricever il msg al termine della procedura di recovery dell'anello
     * prender anche il token.*/
    boolean token;
    
    /** Creates a new instance of OffLineMessage */
    public OffLineMessage(InetAddress addr, int port, String idMsg, Address node, boolean token) {
        super(addr, port, idMsg);
        this.header.setTipo("offline");
        this.node = node;
        this.token = token;
    }
    
    public Address getContent(){
        return this.node;
    }
    
    public boolean withToken(){
        return this.token;
    }
}
