/*
 * NewCloserMessage.java
 *
 * Created on 14 aprile 2004, 10.15
 */

package Src.Servizi.NetworkSupport;

/**
 *
 * @author  Monaco Luca
 */
import java.net.*;
import java.util.*;
import java.io.*;

public class NewCloserMessage extends Message{
    
    protected Address[] nodi;
    
    protected String event;
    
    protected boolean token;
    
    /** Creates a new instance of NewCloserMessage */
    public NewCloserMessage(InetAddress addr, int port, String idMsg, Address nP, Address nS, Address nS2, String event,boolean token) 
    {
        super(addr, port, idMsg);
        this.getHeader().setTipo("newCloser");
        this.nodi = new Address[3];
        this.nodi[0] = nP;
        this.nodi[1] = nS;
        this.nodi[2] = nS2;
        this.event=event;
        this.token=token;
    }
    
    public Address[] getContent()
    {
        return this.nodi;
    }
    
    public String getEvent()
    {
        return this.event;
    }
    
    public void setNewSecondNext(Address nS2)
    {
        this.nodi[2] = nS2;
    }
    
    public void setNewLastNode(Address addr){
        this.nodi[0] = addr;
    }
    
    public boolean withToken(){
        return this.token;
    }
}
