/*
 * NetworkNode.java
 *
 * Created on 6 aprile 2004, 19.45
 */

package Src.Servizi.NetworkSupport;

/**
 *
 * @author  Monaco Luca
 */
import java.net.*;
import java.io.*;


/**La classe rappresenta un nodo di una rete organizzata in una struttura a ring.*/
public class NetworkNode implements Serializable {
    
    /**Nome univoco del nodo.*/
    protected InetAddress addr;
    
    /**Porta utilizzata del nodo per erogare i servizi.*/
    protected int port;
    
    /**Gestore dei canali di connessione con i nodi successivi*/
    protected ClientManager cm;
    
    /**Gestore del canale di connessione con il nodo precedente*/
    protected ServerManager sm;
    
    /**Nome dei nodi vicini:
     * closeHostNames[0] --> Nome del nodo precedente.
     * closeHostNames[1] --> Nome del nodo successivo.
     * closeHostNames[2] --> Nome del nodo successivo al successivo.*/
    protected Address[] closeNodes = new Address[3];
       
 
    
    /*Costruttori: */
    
    public NetworkNode()
    {}
        
    public NetworkNode(InetAddress addr, int port)
    throws UnknownHostException, IOException
    {
        new NetworkNode(port);
        this.addr=addr;
    }
    
   
    
    public NetworkNode(int port)
    throws UnknownHostException
    {
        this.addr = InetAddress.getLocalHost();
        this.port = port;
        this.closeNodes[0] = new Address(this.addr,this.port);
        this.closeNodes[1] = new Address(this.addr,this.port);
        this.closeNodes[2] = new Address(this.addr,this.port);
        
        this.sm = new ServerManager(port,this);
    }
    
    public void setPort(int p)
    {
        this.port = p;
    }
    
    public void setNextNode(Address node)
    {
        this.closeNodes[1] = node;
    }
    
    public void setLastNode(Address node)
    {
        this.closeNodes[0] = node;
    }
    
    /**Per settare il secondo nodo successivo mi faccio passare il nodo successivo*/
    public void setNextSecondNode(Address node)
    {
        //this.closeNodes[2] = node.getNextNode();
        this.closeNodes[2] = node;
    }
    
    
    public Address getNextNode()
    {
        return this.closeNodes[1];
    }
    
    public Address getLastNode()
    {
        return this.closeNodes[0];
    }
    
    public Address getNextSecondNode()
    {
        return this.closeNodes[2];
    }
    
    
    public int getPort(){
        return this.port;
    }
    
    public InetAddress getAddress(){
        return this.addr;
    }
    
    
    /**Permette al nodo di connettersi con il suo successivo.*/
    public void connectToNextNode()
    throws IOException
    {
        if (this.cm==null) this.cm = new ClientManager(this.getNextNode().getAddress(),this.getNextNode().getPort(),this);
        else this.cm.connectTo(this.getNextNode().getAddress(),this.getNextNode().getPort());
    }
    
    
    public ClientManager getCm(){
        return this.cm;
    }
    
    public ServerManager getSm(){
        return this.sm;
    }
    
    public void resetSm(){
        this.sm = new ServerManager(this.getPort(),this);
    }
    
    /**Permette di far entrare un nuovo nodo, che verra posizionato successivamente a this*/
    public NetworkNode addInNet()
    throws IOException, InterruptedException
    {
        
        //Creo un nuovo nodo su la porta successiva a quella di questo nodo.
        int port = this.port+1;
        NetworkNode node = new NetworkNode(port);
        System.out.println("Nodo "+this.getPort()+":Entra un nuovo nodo in servizio sulla porta "+port);
        
        Address temp = this.getNextNode();
        this.setNextNode(new Address(node.getAddress(),node.getPort()));
        this.setNextSecondNode(new Address(temp.getAddress(),temp.getPort()));
        node.setNextNode(temp);
        node.setLastNode(new Address(this.getAddress(),this.getPort()));
       // temp.setLastNode(node);
        
      //  node.setNextSecondNode(node.getNextNode().getNextNode());
      //  this.getLastNode().setNextSecondNode(this.getNextNode().getNextNode());
        System.out.println("Nodo "+this.getPort()+": Il mio nuovo successivo  "+this.getNextNode().getPort());
        System.out.println("Nodo "+this.getPort()+": Il mio nuovo precedente  "+this.getLastNode().getPort());
        System.out.println("Nodo "+this.getPort()+": Il mio secondo successivo  "+this.getNextSecondNode().getPort());
       
        //Chiudo la connessione con il veccio nodo successivo
        if (this.cm!=null){ 
            this.cm.closeConnection();
            //this.getNextSecondNode().resetSm();
        }
        //Apro la nuova connessioni 
        this.connectToNextNode();
        node.connectToNextNode();
        
        node.getCm().sendNewCloserMessage(node.getLastNode(),node.getNextNode(),node.getNextSecondNode(),"add",true);
        //Apro la nuova connessione tra il nodo entrante ed il suo successivo
        //this.getNextNode().connectToNextNode();
        
        return node;
    }
    
    
    /**Il metodo permette di inviare un messaggio di tipo testuale a un nodo connesso.
     *@param msg Il messaggio da inviare.
     *@param direction "next"-->Verso il nodo seguente.
                       "last"-->Verso il nodo precedente.
     *@return True se il messaggio  stato inviato.*/
    public boolean sendString(String msg,String direction)
    throws InterruptedException, IOException
    {
        if(direction.equals("next")){
                this.cm.sendString(msg);
                return true;
        }
        else if(direction.equals("last")){
            this.sm.sendString(msg);
            return true;
        }    
        else return false;
    }
    
    
    /**Il metodo permette di ricevere un messaggio di tipo testuale a un nodo connesso.
     *@param direction "next"-->Dal nodo seguente.
                       "last"-->Dal nodo precedente.
     *@return Il messaggio rivecuto.*/
    public String receiveString(String direction)
    throws IOException, ClassNotFoundException
    {
        String ret;
        if(direction.equals("next"))
            ret = this.cm.receiveString();
        else if(direction.equals("last"))
            ret = this.sm.receiveString();
        else return ret="Error";
        return ret;
    }
    
      
    /**Permette l'invio di un messaggio di verifica di esitenza dell'anello chiuso.*/
  /*  public boolean sendMessageRing(String msg)
    throws InterruptedException, IOException, ClassNotFoundException
    {
        this.cm.sendString(msg);
        String s = this.getNextNode().receiveString("last");
        this.getNextNode().sendMessageRing(s);
        return true;
    }*/
    
    
    /**Permette l'invio di un generico messaggio verso il successivo*/
    public boolean sendMessage(Message msg)
    throws InterruptedException, IOException
    {
        this.cm.sendMessage(msg);
        return true;
    }
    
    /**Permette di ricevere un qualsiasi Messaggio dal precedete*/
    public Message receiveMessage()
    throws IOException, ClassNotFoundException
    {
        return this.sm.receiveMessage();
    }
    
    
    
     public String toString()
    {
        String ret="";
        ret += "Indirizzo nodo: "+this.getAddress()+":"+this.getPort()+"\n";
        ret += "Connessione al nodo precedente:" + this.getLastNode().getPort()+"\n";
        ret += "Connessione al nodo successivo:" + this.getNextNode().getPort()+"\n";
        ret += "Connessione al secondo nodo successivo:" + this.getNextSecondNode().getPort()+"\n";
        return ret;
    }
}
