/*
 * ClientManager.java
 *
 * Created on 7 aprile 2004, 9.22
 */

package Src.Servizi.NetworkSupport;

/**
 *
 * @author  Monaco Luca
 */
import java.io.*;
import java.net.*;

/**La classe si occupa della creazione e della gestione della connessione con il nodo successivo all'interno del ring.*/
public class ClientManager extends Thread implements Serializable{
    
    /**Host del Server sul quale ci si vuol connettere.*/
    protected InetAddress host;
    
    /**Porta sulla quale il server  in ascolto.*/
    protected int port;
    
    /**Connessione gestita dal manager*/
    protected Socket connection;
    
    /**Nodo di rete associato al getsore.*/
    protected NetworkNode node;
    
    protected ObjectInputStream in;
    protected ObjectOutputStream out;
    
    /** Creates a new instance of ClientManager */
    public ClientManager()
    {}    
    
    public ClientManager(InetAddress host, int port, NetworkNode node)
    throws IOException
    {
        this.node=node;
        this.port=port;
        this.host=host;
        start();
    }
    
    public void run()
    {
        try{
            this.connectTo(this.host,this.port);
        }
        catch(Exception e){
            System.out.println(e.getMessage());
        }
    }
    
    /**Il metodo effettua la connessione a un server specificato.*/
    public void connectTo(InetAddress host,int port)
    throws IOException
    {
        this.host=host;
        this.port=port;
        System.out.println("Nodo "+node.getPort()+":Richiedo Connessione al nodo: "+this.port);
        try{
            this.connection = new Socket(host,port);
                              
            this.out  = new ObjectOutputStream(this.connection.getOutputStream());
            this.in   = new ObjectInputStream(this.connection.getInputStream());
        }
        catch(Exception exc){
            System.out.println("ECCEZIONE Nodo "+node.getPort()+":ClientManage.connectTo():"+exc.getMessage());
        }
        System.out.println("Nodo "+node.getPort()+":Connesso al nodo "+this.connection.getPort()+" effettuata con successo!");
        return; 
    }
    
    
    /**permette la chiusura della connessione*/
    public void closeConnection()
    throws IOException, InterruptedException
    {
        //this.sleep(1000);
        try{
            System.out.println("Nodo "+node.getPort()+" Richiesta disconnessione a"+this.getConnectionPort()+"...");
            this.connection.close();
            System.out.println("Nodo "+node.getPort()+":Disconnessione al nodo "+this.connection.getPort()+" effettuata con successo!");
        }
        catch(Exception exc){
            System.out.println("ECCEZIONE Nodo "+node.getPort()+":ClientManage.closeConnetion():"+exc.getMessage());
        }
       // this.in.close();
       // this.out.close();
    }    
    
    /**Per il recupero della porta connessa*/
    public int getConnectionPort()
    {
        return this.connection.getPort();
    }  
    
    public Socket getConnection()
    {
        return this.connection;
    }  
    
    /**Permette l'invio di un messaggio verso il nodo successivo.*/
    public void sendString(String msg) 
    throws InterruptedException, IOException
    {
        this.sleep(100);
        System.out.println("Client "+this.node.getPort()+": Invio del msg:  "+msg+" verso "+this.connection.getPort());
        this.out.writeObject(new String(msg));
    }
    
    /**Permette di ricevere un messaggio di risposta (tipo Ack) dal nodo successivo.*/
    public String receiveString()
    throws IOException, ClassNotFoundException
    {
        String ret = (String)this.in.readObject();
        System.out.println("Client "+this.node.getPort()+":  arrivato il msg: "+ret);
        return ret;
    }
    
    
    /**Permette l'invio di un qualusiasi messaggio.*/
    public void sendMessage(Message msg)
    throws InterruptedException, IOException
    {
        this.sleep(100);
        System.out.println("Client "+this.node.getPort()+": Invio del msg:  "+msg.getHeader().getIdMsg()+" verso "+this.connection.getPort());
        this.out.writeObject(msg);
    }

    public void sendMessage(Message msg, String io)
    throws InterruptedException, IOException
    {
        this.sleep(100);
        System.out.println("Client "+this.node.getPort()+": Inoltro il messaggio "+io+ " verso "+this.connection.getPort());
        this.out.writeObject(msg);
    }
    
    /**Permette di ricevere un qualunque messaggio.*/
    public Message receiveMessage()
    throws IOException, ClassNotFoundException
    {
        Message ret = (Message)this.in.readObject();
        System.out.println("Client "+this.node.getPort()+":  arrivato il msg: "+ret.getHeader().getIdMsg());
        return ret;
    }
    
    //Token=true indica che alla fine della procedura di recovery, il nodo gestore acquisisce il token.
    //Token=false indica che alla fine della procedura di recovery, il nodo gestore inoltra il messaggio di AreYouAlive.
    public void sendNewCloserMessage(Address nP,Address nS,Address nS2,String event,boolean token)
    throws InterruptedException, IOException
    {
        Address address = new Address(this.node.getAddress(), this.node.getPort());
        NewCloserMessage msg = new NewCloserMessage(this.node.getAddress(),this.node.getPort(),"$$$$$$$$$$$$$$$$  "+this.node.getPort()+":newCloser MESSAGE  $$$$$$$$$$$$$$$$",nP,nS,nS2,event,token);
        this.sendMessage(msg);
    }
    
    /**Permette di inoltrare un messaggio di update verso il successivo.*/
    public void passNewCloserMessage(NewCloserMessage msg)
    throws InterruptedException, IOException
    {
          this.sendMessage(msg);
    }
}
