/*
 * TokenTimeout.java
 *
 * Created on 16 aprile 2004, 15.23
 */

package Src.LogicaDistribuito;

/**
 *
 * @author  Monaco Luca
 */
import Src.Servizi.NetworkSupport.*;
import Src.Servizi.Exception.*;

public class TokenTimeout extends Timeout
{
    CreationTokenManager manager;
    
        
    /** Creates a new instance of TokenTimeout */
    public TokenTimeout(int t,NodoClassificatore n, CreationTokenManager manager) {
        super(t, n, "tokenTimeout");
        this.manager = manager;
    }
    
    public void run()
    {
        try{
            sleep(this.time);
            throw new TimeoutException();
        }
        catch(InterruptedException e){
            System.out.println(e.getMessage());
        }
        catch(TimeoutException e){
            try{
                System.out.println("Nodo "+this.nodo.getPort()+": TOKEN TIMEOUT SCADUTO!");
                this.manager.manageTimeout();
            }
            catch(Exception er){
                System.out.println(er.getMessage());
            }
        }
    }
}
