/*
 * ServerThreadClassificatore.java
 *
 * Created on 8 aprile 2004, 21.32
 */

package Src.LogicaDistribuito;

/**
 *
 * @author  Monaco Luca
 */
import java.net.*;
import java.io.*;
import Src.Servizi.NetworkSupport.*;
import Src.Logica.*;
import javax.xml.parsers.*;
import org.xml.sax.SAXException;
import Src.Servizi.Exception.*;

public class ServerThreadClassificatore extends ServerThread
{
        
    /** Creates a new instance of ServerThreadClassificatore */
    public ServerThreadClassificatore(int port, NodoClassificatore node, Socket s)
    throws IOException
    {
        super(port,node,s);
    }
    
    public void closeConnetion()
    throws IOException
    {
        this.connection.close();
    }
    
    /**Permette di ricevere un qualunque messaggio: effettua il disptache dei messagi in ingresso.*/
    public Message receiveMessage()
    throws IOException, ClassNotFoundException, InterruptedException, ParserConfigurationException, SAXException, AttributeNotFoundException
    {
        
        Message ret = (Message)this.in.readObject();
        //try{
            if (ret.getHeader().getTipo().equals("collect"))
                ((NodoClassificatore)this.node).manageCollectMessage((CollectMessage)ret);
            
            else if (ret.getHeader().getTipo().equals("update")){
                 //if (this.node.getPort()==2003) sleep(999999999); 
                ((NodoClassificatore)this.node).manageUpdateMessage((UpdateMessage)ret);
            }
            
            else if (ret.getHeader().getTipo().equals("initialize"))
                ((NodoClassificatore)this.node).manageInitializeMessage((InitializeMessage)ret);
            
            else if (ret.getHeader().getTipo().equals("token")){
                int t=0;
                //if (this.node.getPort()==2002) t=999999999;
                this.sendILiveMessage(t,false);
                sleep(100);
                ((NodoClassificatore)this.node).manageTokenMessage((TokenMessage)ret);
            }
            
            else if (ret.getHeader().getTipo().equals("AreYouLive") ||
                    ret.getHeader().getTipo().equals("electionToken")){
                int t=0;
                //if (this.node.getPort()==2003) t=999999999;
                this.sendILiveMessage(t,true);
                sleep(100);
                ((NodoClassificatore)this.node).manageAreYouLiveMessage((AreYouLiveMessage)ret);
            }
            
            else if (ret.getHeader().getTipo().equals("newCloser"))
                ((NodoClassificatore)this.node).manageNewCloserMessage((NewCloserMessage)ret);
            
            else if (ret.getHeader().getTipo().equals("offline"))
                ((NodoClassificatore)this.node).manageOffLineMessage((OffLineMessage)ret);
            
           
        /*}
        catch(Exception e){
            System.out.println("Server "+ this.node.getPort()+":Eccezione in ServerThreadClassificatore.receiveMessage():"+e.getMessage());
        }*/
        return ret;
    }
    
    /**Permette di inviare dopo un tempo t in millisecondi il messaggio di sendILive*/
    public void sendILiveMessage(int t,boolean recoveryMsg)
    throws InterruptedException, IOException
    {
        sleep(t);
        ILiveMessage msg = new ILiveMessage(this.node.getAddress(),this.node.getPort(),"xxxxxxxxx  "+this.node.getPort()+": I LIVE MESSAGE  xxxxxxxxx",recoveryMsg);
        this.sendMessage(msg);
    }
}
