/*
 * QueueNetworkManager.java
 *
 * Created on 9 aprile 2004, 15.42
 */

package Src.LogicaDistribuito;

/**
 *
 * @author  Monaco Luca
 */
import Src.Servizi.NetworkSupport.*;
import Src.Logica.*;
import Src.Servizi.Exception.*;
import java.util.*;

/**La classe rappresenta il gestore delle richieste di update e di insert di nuovi nodi.*/
public class QueueNetworkManager extends QueueManager{
    
    
    /**Riferimento al Nodo Classificatore*/
    NodoClassificatore node;
    
    
    /** Creates a new instance of QueueNetworkManager */
    public QueueNetworkManager(NodoClassificatore n) 
    {
       super(); 
       this.node = n; 
    }
       
    
    /**Permette la gestione di un richiesta della coda. Viene gestita prima una e una sola richiesta insert
     * e poi una e una sola richiesta update.*/
    public void manageRequestOn(Queue q)
    {
        try{
            if (q==null){
                sleep(1500);
                this.node.manageEmptyQueues();
            }
            else if(q.getName().equals("insertQueue")){
                System.out.println("Gestore code di "+this.node.getPort()+": Gestione delle coda di INSERT");
                InsertRequest r = (InsertRequest)q.getFirstRequest();
                this.node.manageInsertRequest();
            }
            else if(q.getName().equals("updateQueue")){
                System.out.println("Gestore code di "+this.node.getPort()+": Gestione delle coda di UPDATE");
                UpdateRequest r = (UpdateRequest)q.getFirstRequest();
                this.node.manageUpdateRequest();
            }
            else if(q.getName().equals("offlineQueue")){
                System.out.println("Gestore code di "+this.node.getPort()+": Gestione delle coda di OFFLINE");
                OffLineRequest r = (OffLineRequest)q.getFirstRequest();
                this.node.manageOffLineRequest(r);
            }
            else if(q.getName().equals("failQueue")){
                System.out.println("Gestore code di "+this.node.getPort()+": ORA MI PRENDO IL TOKEN E PIANTO TUTTA LA RETE!");
                FailRequest r = (FailRequest)q.getFirstRequest();
                this.node.manageFailRequest(r);
            }
         }//fine try
        catch(Exception e){
            System.out.println("Gestore code di "+this.node.getPort()+": Eccezione:"+e.getMessage());
        }
    }
    
    public void manageRequests() 
    {
        Queue q1 = this.node.getQueue("insertQueue");
        Queue q2 = this.node.getQueue("updateQueue");
        Queue q3 = this.node.getQueue("offlineQueue");
        Queue q4 = this.node.getQueue("failQueue");
        //Gestisco prima la coda di insert poi quella di upadate
        if (q1.getSize()==0 && q2.getSize()==0 && q3.getSize()==0 && q4.getSize()==0){
            System.out.println("Nodo "+this.node.getPort()+":Non ci sono richieste da gestire.");
            this.manageRequestOn(null);
        }
        if (q4.getSize()>0) this.manageRequestOn(q4);
        if (q1.getSize()>0) this.manageRequestOn(q1);
        if (q2.getSize()>0) this.manageRequestOn(q2);
        if (q3.getSize()>0) this.manageRequestOn(q3);
        
    }
    
}
