/*
 * classifyManager.java
 *
 * Created on 13 aprile 2004, 15.07
 */

package Src.LogicaDistribuito;

/**
 *
 * @author  Monaco Luca
 */
import Src.Servizi.NetworkSupport.*;
import Src.Logica.*;
import Src.Servizi.Exception.*;
import java.util.*;



/**La classe modella un processo che si occupa di gestire la coda delle richieste di classificazione.*/
public class QueueClassifyManager extends QueueManager
{
    
    /**Riferimento al Nodo Classificatore*/
    NodoClassificatore node;
    
    /** Creates a new instance of classifyManager */
    public QueueClassifyManager(NodoClassificatore n) 
    {
       super(); 
       this.node = n; 
    }
    
    
    public void manageRequestOn(Queue q)
    {
        try{
            while(this.node.isUpdated() && q.getSize()>0){
                ClassifyRequest cr = (ClassifyRequest)q.getFirstRequest();
                this.node.manageClassifyRequest(cr);
            }
        }
        catch(Exception e){
            System.out.println(e.getMessage());
        }
    }
    
    public void manageRequests() 
    {
        System.out.println("Gestore CODA CLADDIFY "+this.node.getPort()+": Gestione delle richieste pendenti...");
        Queue q1 = this.node.getQueue("classifyQueue");
        this.manageRequestOn(q1);
    }
    
}
