/*
 * NodoClassificatore.java
 *
 * Created on 8 aprile 2004, 17.31
 */

package Src.LogicaDistribuito;

/**
 *
 * @author  Monaco Luca
 */
import java.net.*;
import java.io.*;
import java.util.*;
import Src.Logica.*;
import Src.Servizi.NetworkSupport.*;
import javax.xml.parsers.*;
import org.xml.sax.SAXException;
import Src.Servizi.Exception.*;

public class NodoClassificatore extends NetworkNode{
    
    /**Classificatore del nodo.*/
    protected Classificatore classificatore;
    
    /**TrainingSet locale al nodo*/
    protected TrainingSet tsLocale;
    
    /**TrainingSet su cui basare la costruzione dell'Albero Decisionale.*/
    protected TrainingSet tsGlobale;
    
    /**In questo insieme vengono inseriti gli esempi nuovi*/
    protected ExampleSet esempiNuovi;
    
    /**Segnala il possesso del token.*/
    protected boolean token;
    
    /**Coda delle richieste di update provenienti dall'esterno.*/
    protected Queue codaUpdate; 
    
    /**Coda delle richieste di insert provenienti dall'esterno.*/
    protected Queue codaInsert; 
    
    /**Coda delle richieste di classify provenienti dall'esterno.*/
    protected Queue codaClassify;
    
    /**Coda delle richieste di uscita dalla rete.*/
    protected Queue codaOffLine;
    
    /**Coda per accettare richieste di simulazione di fail con token.*/
    protected Queue codaFail;
    
    /**Manager delle richieste di Inserimento di nuovi nodi in rete e di Aggiornamento dell'Albero;*/
    protected QueueNetworkManager netRequestManager;
    
    /**Manager delle richieste di classificazione di nuove istanze;*/
    protected QueueClassifyManager classifyManager;
   
    /**Indica se l'albero decisionale  aggiornato oppure no.*/
    protected boolean updated;
    
    /**Processo che si occupa del protocollo di crezione del Token.*/
    protected CreationTokenManager tokenManager;
    
    protected AreYouLiveMessage areYouLive;
    
    protected int tokenTimeout; 
    
    /** Creates a new instance of NodoClassificatore */
    public NodoClassificatore(int port) 
    throws UnknownHostException, IOException
    {
        this.addr = InetAddress.getLocalHost();
        this.port = port;
        this.updated = false;
        Address addr = new Address(this.addr,this.port);
        this.closeNodes[0] = addr;
        this.closeNodes[1] = addr;
        this.closeNodes[2] = addr;
        this.codaOffLine = new Queue("offlineQueue",3);
        this.codaInsert = new Queue("insertQueue",2);
        this.codaUpdate = new Queue("updateQueue",1);
        this.codaClassify = new Queue("classifyQueue",1);
        this.codaFail = new Queue("failQueue",4);
        
        this.sm = new ServerManagerClassificatore(port,this);
        this.netRequestManager = new QueueNetworkManager(this);
        this.classifyManager = new QueueClassifyManager(this);
        
        try{
            this.tsLocale = new TrainingSet();
            this.tsGlobale = new TrainingSet();
            this.esempiNuovi = new ExampleSet();
            this.setToken(false);
        }  
        catch(Exception e){
            System.out.println(e.getMessage());
        }
    }
    
    public NodoClassificatore(int port,int t) 
    throws UnknownHostException, IOException
    {
        new NodoClassificatore(port);
        this.tokenTimeout = t;
        this.tokenManager = new CreationTokenManager(this.tokenTimeout,this);
    }
    
    public Classificatore getClassificatore()
    {
        return this.classificatore;
    }
    
    public CreationTokenManager getCreationTokenManager(){
        return this.tokenManager;
    }
      
    
    public boolean isUpdated()
    {
        return this.updated;
    }
    
    public boolean hasToken()
    {
        return this.token;
    }
    
    
    public void setUpdated(boolean b)
    throws InterruptedException
    {
        if (b){
            System.out.println("Nodo "+this.getPort()+":Riattivazione del gestore di richieste di classificazione.");
            this.updated=true;
            this.classifyManager.resumeManager();
        }
        else{
            System.out.println("Nodo "+this.getPort()+":Sospensione del gestore di richieste di classificazione.");
            this.updated=false;
            this.classifyManager.suspendManager();
        }
    }
    
    
    public void setToken(boolean b)
    throws InterruptedException
    {
        if (b){
            //...Sospendere il processo Manager delle richieste di classificazione
            System.out.println("Nodo "+this.getPort()+":Riattivazione del gestore di richieste di rete.");
            this.token = true;
            this.netRequestManager.resumeManager();
        }
        else{
            System.out.println("Nodo "+this.getPort()+":Sospensione del gestore di richieste di rete.");
            this.token=false;
            this.netRequestManager.suspendManager();
            //...Sospendere il processo Manager delle richieste di classificazione 
        }
    }
    
   /*
    
     public void setNextNode(NodoClassificatore node)
    {
        this.closeNodes[1] = node;
    }
    
    public void setLastNode(NodoClassificatore node)
    {
        this.closeNodes[0] = node;
    }
    
    public void setNextSecondNode(NetworkNode node)
    {
        //this.closeNodes[2] =(NodoClassificatore)node.getNextNode();
        this.closeNodes[2] = node;
    }
    */
    
    public Queue getQueue(String nome)
    {
        if(this.codaInsert.getName().equals(nome)) return this.codaInsert;
        else if(this.codaUpdate.getName().equals(nome)) return this.codaUpdate;
        else if(this.codaOffLine.getName().equals(nome)) return this.codaOffLine;
        else if(this.codaClassify.getName().equals(nome)) return this.codaClassify;
        else if(this.codaFail.getName().equals(nome)) return this.codaFail;
        else return null;
    }
    
    public NetworkNode addInNet()
    throws IOException, InterruptedException
    {
        
        //Creo un nuovo nodo su la porta successiva a quella di questo nodo.
        /*Random r = new Random();
        int n;
        do n=r.nextInt(9999);
        while (n<1024);*/
        
        int n = this.port+1;
        NodoClassificatore node = new NodoClassificatore(n);
        System.out.println("Nodo "+this.getPort()+":Entra un nuovo nodo in servizio sulla porta "+n);
        
        Address temp = this.getNextNode();
        this.setNextNode(new Address(node.getAddress(),node.getPort()));
        this.setNextSecondNode(temp);
        node.setNextNode(temp);
        node.setLastNode(new Address(this.getAddress(),this.getPort()));
        //temp.setLastNode(node);
        
        //node.setNextSecondNode(node.getNextNode().getNextNode());
        //this.getLastNode().setNextSecondNode(getNextNode());
        System.out.println("Nodo "+this.getPort()+": Il mio nuovo successivo  "+this.getNextNode().getPort());
        System.out.println("Nodo "+this.getPort()+": Il mio nuovo precedente  "+this.getLastNode().getPort());
        System.out.println("Nodo "+this.getPort()+": Il mio secondo successivo  "+this.getNextSecondNode().getPort());
       
        //Chiudo la connessione con il veccio nodo successivo
        if (this.cm!=null){ 
            this.cm.closeConnection();
            //this.getNextSecondNode().resetSm();
        }
        //Apro la nuova connessioni
        this.connectToNextNode();
        node.connectToNextNode();
        
        node.cm.sendNewCloserMessage(node.getLastNode(), node.getNextNode(), node.getNextSecondNode(), "add",true);
        
        return node;
    }
   
    
    
    public void creaClassificatore(TrainingSet ts)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException,ElementNotFoundException, AttributeNotFoundException
    {
        //String nomeFileDich = "c:/progetti/Classificatore/DicchiarazioneZoo.xml";
        //Dichiarazione dich = new Dichiarazione(nomeFileDich);
        //TrainingSet ts = new TrainingSet(es, dich);
        this.classificatore = new Classificatore(ts);           
    }
    
    /**Per il recupero degli esempi nuovi accumulati. Quando vengono raccolti non sono pi considerati
     * esempi nuovi quindi possono essere aggiunti al TS locale.*/
    public ExampleSet getNuoviEsempi()
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        ExampleSet ret = this.esempiNuovi;
        this.esempiNuovi = new ExampleSet();
        
        return ret;
    }
    
    
    /**Verifica se un esempio  coperto*/
    public boolean isCovered(Esempio es)
    throws AttributeNotFoundException
    {
        return this.classificatore.isCovered(es);
    }
    
    
    /**Permette di inserire un nuovo esempio nell'insieme degli esempi nuovi.*/
    public void addNewExample(Esempio es)
    {
        this.esempiNuovi.addEsempio(es);
    }
    
    /**Permette di gestire una richiesta di Raccolta.
     *@param es Insieme di esempi raccolti fino a certo momento*/
    public ExampleSet addNewExamples(ExampleSet es)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        ExampleSet ret = new ExampleSet();
        
        for(int i=0;i<this.esempiNuovi.getSize();i++)
            this.tsLocale.addEsempio(esempiNuovi.getEsempio(i));
                
        for(int i=0;i<es.getSize();i++)
            ret.addEsempio(es.getEsempio(i));
        
        for(int i=0;i<this.esempiNuovi.getSize();i++)
            ret.addEsempio(esempiNuovi.getEsempio(i));
        
        //
        return ret;
    }
    
    /**Permette di gestire una richiesta di aggiornamento.
     *@param es Insieme Totale degli esempi raccolti, da aggiungere al TrainingSet globale.*/
    public void updateTree(ExampleSet es)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException, InterruptedException
    {
        this.emptyUpdateQueue();
        this.esempiNuovi = new ExampleSet();
        
        System.out.println("Nodo "+this.getPort()+": Aggiornamento dell'Albero...");
        for(int i=0;i<es.getSize();i++)
            this.tsGlobale.addEsempio(es.getEsempio(i));
        
        this.classificatore = new Classificatore(this.tsGlobale);
        System.out.println("Nodo "+this.getPort()+": Aggiornameto dell'albero effettuato con successo!");
        this.setUpdated(true);
    }
    
    
    /**Permette al nodo di connettersi con il suo successivo.*/
    public void connectToNextNode()
    throws IOException
    {
        if (this.cm==null) this.cm = new ClientManagerClassificatore(this.getNextNode().getAddress(),this.getNextNode().getPort(),this);
        else this.cm.connectTo(this.getNextNode().getAddress(),this.getNextNode().getPort());
    }
    
        
    /**Per la gestione di un Messaggio di collect.*/
    public void manageCollectMessage(CollectMessage ret)
    throws InterruptedException, IOException, ParserConfigurationException, SAXException, AttributeNotFoundException
    {
        //try{
            if (ret.getHeader().getfromPort()==this.getPort() &&
            ret.getHeader().getfromAddr().equals(this.getAddress()))
            {
                ((ClientManagerClassificatore)this.cm).getTimeout().ferma();
                System.out.println("Server "+ this.getPort()+":Ho ricevuto un msg Collect Message creato da me");
                ExampleSet es = ret.getContent();
                System.out.println("Server "+ this.getPort()+":ExampleSet raccolto: ");
                System.out.println(es);
                ((ClientManagerClassificatore)this.cm).sendUpdateMessage(es);
                //Aggiorno il mio albero.
                this.updateTree(es);
            }
            else{
                this.setUpdated(false);
                System.out.println("Server "+ this.getPort()+":Ho ricevuto un msg Collect Message creato da "+ret.getHeader().getfromPort());
                ExampleSet es = ret.getContent();
                System.out.println("Server "+ this.getPort()+":ExampleSet raccolto fin'ora: ");
                System.out.println(es);
                if (this.esempiNuovi.getSize()>0)
                    es = this.addNewExamples(es);
                System.out.println("Server "+ this.getPort()+":ExampleSet che sto per inviare: ");
                System.out.println(es);
                ((ClientManagerClassificatore)this.cm).passCollectMessage(ret,es);
                
            }
        /*}
        catch(Exception e){
            System.out.println("Server "+ this.getPort()+":ECCEZIONE manageCollectMessage()"+e.getMessage());
        }*/
    }
    
    
    /**Per la gestione di un Messaggio di collect.*/
    public void manageUpdateMessage(UpdateMessage ret)
    throws InterruptedException, IOException, ParserConfigurationException, SAXException, AttributeNotFoundException, ClassNotFoundException
    {
        //try{
            if (ret.getHeader().getfromPort()==this.getPort() &&
            ret.getHeader().getfromAddr().equals(this.getAddress()))
            {
                ((ClientManagerClassificatore)this.cm).getTimeout().ferma();
                System.out.println("Server "+ this.getPort()+":Ho ricevuto un msg UpdateMessage creato da me");
                ((ClientManagerClassificatore)this.cm).sendTokenMessage();
            }
            else{
                System.out.println("Server "+ this.getPort()+":Ho ricevuto un msg UpdateMessage creato da "+ ret.getHeader().getfromPort());
                ExampleSet es = ret.getContent();
                ((ClientManagerClassificatore)this.cm).passUpdateMessage(ret);
                
                //Aggiorno il mio albero.
                this.updateTree(es);
            }
        /*}
        catch(Exception e){
            System.out.println("Server "+ this.getPort()+":ECCEZIONE manageUpdateMessage()"+e.getMessage());
        }*/
    }

    /**Per la gestione di un Messaggio per il passaggio del token.*/
    public void manageTokenMessage(TokenMessage m)
    {
        try{
            if(this.tokenManager!=null){
                System.out.println("Nodo "+this.getPort()+":Reset del token timeout");
                this.tokenManager.resetTimeout();
                System.out.println("Nodo "+this.getPort()+":Il mio nuovo token timeout  "+this.tokenManager.getTokenTimeout());
                if (this.tokenManager.getETSended()) this.tokenManager.setInvalided();
            }
            this.setToken(true);
        }
        catch(Exception e){
            System.out.println("Server "+ this.getPort()+":ECCEZIONE manageTokenMessage()"+e.getMessage());
        }    
    }


    /**Per la gestione di un Messaggio di collect.*/
    public void manageInitializeMessage(InitializeMessage ret)
    {
        try{
            TrainingSet ts = ret.getContent();
            System.out.println("Server "+ this.getPort()+":Creazione dell'Albero decisionale...");
            this.creaClassificatore(ts);
            System.out.println("Server "+ this.getPort()+":Creazione avvenuta con successo!...");
        }
        catch(Exception e){
            System.out.println("Server "+ this.getPort()+":ECCEZIONE manageInitializeMessage()"+e.getMessage());
        }
    }

    
    /**Per la gestione di un Messaggio di ack in seguito all'invio del token.*/
    public void manageILiveMessage(ILiveMessage m)
    {
        try{
            if(!m.isRecoveryMsg())
                this.setToken(false);
        }
        catch(Exception e){
            System.out.println("Nodo "+ this.getPort()+":ECCEZIONE manageILiverMessage()"+e.getMessage());
        }
    }
    
    
    
    /**Metodo per simulare l'arrivo di una richiesta di Insert*/
    public void receivedIsertRequest(InsertRequest ir)
    throws AttributeNotFoundException
    {
        this.codaInsert.putInQueue(ir);                
    }
    
    /**Il metodo permette di aggiungere in coda una richiesta di update qualsiasi:
     * L'osservazione contenuta viene sempre inserita in nuovi esempi. La richiesta viene
     * invece depositata in coda solo se l'osservazione non  coperta dall'albero attuale.*/
    public void receivedUpdateRequest(UpdateRequest ur)
    throws AttributeNotFoundException
    {
        System.out.println("Nodo "+ this.getPort()+": Ho effettuato questa NUOVA OSSERVAZIONE: "+ur.getContent());
        Esempio es = ur.getContent();
        this.addNewExample(es);
        if (this.classificatore==null || !this.isCovered(es)){
            System.out.println("Nodo "+ this.getPort()+": NON  gi coperta dall'albero attuale --> La metto in coda.");
            this.codaUpdate.putInQueue(ur);
        }
        else System.out.println("Nodo "+ this.getPort()+": E' gi coperta dall'albero attuale --> Metto solo l'osservarzione nella lista dei nuovi esempi.");
    }
    
    
    /**Metodo per simulare una richiesta di Classificazione.*/
    public void receivedClassifyRequest(ClassifyRequest cr)
    throws AttributeNotFoundException
    {
        if (this.codaClassify.getSize()==0 && this.isUpdated())
            this.manageClassifyRequest(cr);
        
        this.codaClassify.putInQueue(cr);
    }
    
    /**Metodo per simulare una richiesta di Uscita.*/
    public void receivedOffLineRequest(OffLineRequest or)
    throws AttributeNotFoundException
    {
        this.codaOffLine.putInQueue(or);      
    }

    
    /**Permette di eliminare ogni richiesta nella coda di Update*/
    public void emptyUpdateQueue()
    {
        this.codaUpdate.reset();                
    }
    
    
    /**Metodo per gestire un UpdateRequest.*/
    public void manageUpdateRequest()
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException, InterruptedException
    {
        this.setUpdated(false);
        ExampleSet eSet = new ExampleSet();
        for(int i=0;i<this.esempiNuovi.getSize();i++)
            eSet.addEsempio(this.esempiNuovi.getEsempio(i));
        ((ClientManagerClassificatore)this.cm).sendCollectMessage(eSet);
        this.emptyUpdateQueue();
    }
    
    
    /**Metodo per gestire un InsertRequest.*/
    public void manageInsertRequest()
    throws IOException, InterruptedException, ClassNotFoundException
    {
        this.addInNet();
        
        //Gli invio il TrainingSet Globale Attuale
        if(this.tsGlobale.getSize()>0)
            ((ClientManagerClassificatore)this.cm).sendInitializeMessage(this.tsGlobale);
        
        ((ClientManagerClassificatore)this.cm).sendTokenMessage();
    }
    
    /**Metodo per gestire un InsertRequest.*/
    public void manageOffLineRequest(OffLineRequest r)
    throws IOException, InterruptedException, ClassNotFoundException
    {
        Address addr = new Address(this.getAddress(),this.getPort());
        ((ClientManagerClassificatore)this.cm).sendOffLineMessage(addr,true);
        this.cm.closeConnection();
        //((ClientManagerClassificatore)this.cm).sendTokenMessage();
    }
    
    /**Gestione della situazione in cui non ci sono richieste esterne da gestire.*/
    public void manageEmptyQueues()
    throws IOException, InterruptedException, ClassNotFoundException
    {
        
        ((ClientManagerClassificatore)this.cm).sendTokenMessage();
    }
    
    
    public String manageClassifyRequest(ClassifyRequest cr)
    throws AttributeNotFoundException
    {
        Istanza i = cr.getContent();
        String classe = this.classificatore.classifica(i); 
        System.out.println("L'istanza  stata classificata "+classe);
        return classe;
    }
    
    /**La classe permette di gestire la caduta del nodo successore.
     * Se token vale true il gestore della procedur di recovery, al temrine dell'operazione acquisisce anche
     * il token.*/
    public void manageNodeFail()
    {
        try{
            System.out.println("Nodo "+ this.getPort()+":Gestione della caduta del mio nodo successivo.");
            //Elimino le vecchie connessioni;
            Address oldNext = this.getNextNode();
            this.cm.closeConnection();
            this.setNextNode(this.getNextSecondNode());
            this.connectToNextNode();
            ((ClientManagerClassificatore)this.cm).sendOffLineMessage(oldNext,true);
        }
        catch(Exception e){
            System.out.println("Nodo "+ this.getPort()+":Eccezione su manageFailNode():"+e.getMessage());
        }
    }
    
    
    /**Il metodo si proccupa della gestione di un messaggio di NewCloser pervenuto.*/
    public void manageNewCloserMessage(NewCloserMessage msg)
    {
        try{
            Address[] nodi = msg.getContent();
            Address addr = new Address(msg.getHeader().getfromAddr(),msg.getHeader().getfromPort());
            if(msg.getEvent().equals("add")){
                if (msg.getHeader().getfromPort()==this.getPort() &&
                    msg.getHeader().getfromAddr().equals(this.getAddress()))
                
                    this.setNextSecondNode(nodi[2]);
                  
                else if(this.getNextNode().getPort() == nodi[0].getPort()){
                    this.setNextSecondNode(new Address(msg.getHeader().getfromAddr(),msg.getHeader().getfromPort()));
                    System.out.println("Nodo "+this.getPort()+": Il mio secondo successivo sar "+this.getNextSecondNode().getPort());
                    ((ClientManagerClassificatore)this.cm).passNewCloserMessage(msg);
                }
            
                else if(nodi[1].getPort()==this.getPort()){
                    this.setLastNode(new Address(msg.getHeader().getfromAddr(),msg.getHeader().getfromPort()));
                    msg.setNewSecondNext(this.getNextNode());
                    ((ClientManagerClassificatore)this.cm).passNewCloserMessage(msg);
                }
            
                else if(nodi[0].getPort()==this.getPort()){
                    this.setNextNode(addr);
                    this.setNextSecondNode(nodi[1]);
                    ((ClientManagerClassificatore)this.cm).passNewCloserMessage(msg);
                }
                 
                else ((ClientManagerClassificatore)this.cm).passNewCloserMessage(msg);
            }
            else if(msg.getEvent().equals("offline")){
                if (msg.getHeader().getfromPort()==this.getPort() &&
                    msg.getHeader().getfromAddr().equals(this.getAddress())){
                    
                        this.setLastNode(nodi[0]);
                        
                        if (msg.withToken())  this.setToken(true);  
                        else ((ClientManagerClassificatore)this.cm).passAreYouLiveMessage(this.areYouLive);
                }
                else if(this.getNextSecondNode().getPort()==nodi[0].getPort()){
                    this.setNextSecondNode(new Address(msg.getHeader().getfromAddr(),msg.getHeader().getfromPort()));
                    ((ClientManagerClassificatore)this.cm).passNewCloserMessage(msg);
                }
                
                else if(this.getNextNode().getPort()==nodi[0].getPort()){
                    this.cm.closeConnection();
                    System.out.println("Nodo "+this.getPort()+": Il mio successivo sar "+addr.getPort());
                    this.setNextNode(addr);
                    this.connectToNextNode();
                    msg.setNewLastNode(new Address(this.addr,this.port));
                    this.setNextSecondNode(nodi[1]);
                    ((ClientManagerClassificatore)this.cm).passNewCloserMessage(msg);
                }
                
                else ((ClientManagerClassificatore)this.cm).passNewCloserMessage(msg);
            }
        
        }
        catch(Exception e){
            System.out.println("Nodo "+ this.getPort()+":ECCEZIONE manageNewCloserMessage()"+e.getMessage());
        }
   }
    
    
    /**Permette di gestire l'uscita volontaria o non, del nodo precedente(addr) e alla fine del recovery 
     * il gestore ACQUISICE IL TOKEN.*/
    public void manageOffLineMessage(OffLineMessage msg)
    throws InterruptedException, IOException
    {
        Address addr = msg.getContent();
        this.cm.sendNewCloserMessage(addr, this.getNextNode(), this.getNextSecondNode(), "offline", true);
    }

    
    /**La funzione gestisce il lancio di un eccezione dovuta allo scadere di un time out*/
    public void findWhoFailed(String tipo)
    throws InterruptedException, IOException, ClassNotFoundException
    {
        ((ClientManagerClassificatore)this.cm).sendAreYouLiveMessage(null);
    }
    
    public void manageAreYouLiveMessage(AreYouLiveMessage msg)
    {
        try{
            if(msg.getNodeFailAddress()!=null){
                Address addr = msg.getNodeFailAddress();
                System.out.println("Nodo "+ this.getPort()+":Sono stato incaricato di gestire la procedura di Recovery.");
                msg.setNodeFailAddress(null);
                this.areYouLive = msg;
                this.cm.sendNewCloserMessage(addr, this.getNextNode(), this.getNextSecondNode(), "offline",false);
            }
        
            else if (msg.getHeader().getfromPort()==this.getPort() &&
                     msg.getHeader().getfromAddr().equals(this.getAddress())){
                    
                    if (msg.getHeader().getTipo().equals("AreYouLive")) 
                        this.netRequestManager.manageRequests();
                    else if (msg.getHeader().getTipo().equals("electionToken"))
                        this.tokenManager.manageElectionTokenMessage((ElectionTokenMessage)msg);
            }
            
            else{
                if (msg.getHeader().getTipo().equals("AreYouLive")) 
                    ((ClientManagerClassificatore)this.cm).passAreYouLiveMessage(msg);
                else if (msg.getHeader().getTipo().equals("electionToken"))
                     this.tokenManager.manageElectionTokenMessage((ElectionTokenMessage)msg);
            }
        }
        catch(Exception e){
            System.out.println("Server "+ this.getPort()+":ECCEZIONE manageAreYouLiveMessage()"+e.getMessage());
        }    
    }
    
    
     /**La classe permette di gestire la caduta del nodo dopo essere che questa  stata rilevata dal
      *processo AreYouLive innescato dalla scadere di un timeout.*/
     public void manageRecoveryRing(AreYouLiveMessage msg)
     {
        try{
            
                System.out.println("Nodo "+ this.getPort()+":Innesco la procedura di Recovery.");
                //Elimino le vecchie connessioni;
                Address oldNext = this.getNextNode();
                this.cm.closeConnection();
                this.setNextNode(this.getNextSecondNode());
                this.connectToNextNode();
                //Inviando address il nodo ricevente capisce che  gestore di un processo di recovery
                //del ring (e alla fine non si prende il token)
                
                if(msg.getHeader().getTipo().equals("AreYouLive")){
                    ((AreYouLiveMessage)msg).setNodeFailAddress(oldNext);
                    ((ClientManagerClassificatore)this.cm).passAreYouLiveMessage((AreYouLiveMessage)msg);
                }
                else{
                    ((ElectionTokenMessage)msg).setNodeFailAddress(oldNext);
                    ((ClientManagerClassificatore)this.cm).passElectionTokenMessage((ElectionTokenMessage)msg);
                }
        }
        catch(Exception e){
            System.out.println("Nodo "+ this.getPort()+":Eccezione su manageRecoveryRing():"+e.getMessage());
        }
    }
     
  /*  
    public void manageElectionTokenMessage(ElectionTokenMessage m)
    throws InterruptedException, IOException
    {
        //Se il nodo  in possesso del token e riceve il mesaggio LO SCARTA.
        if (this.token) {
            System.out.println("Nodo "+ this.getPort()+":Ho ricevuto un messaggio di ET ma io ho il token --> SCARTATO!!");
            return;
        }
        this.tokenManager.manageElectionTokenMessage(m);
    }
    */
    
     public void setTokenTimeout(int t)
    {
        this.tokenTimeout = t;
        this.tokenManager = new CreationTokenManager(this.tokenTimeout,this);
    }
     
    public int getTokenTimeout(){
        return this.tokenManager.getTokenTimeout();
    } 

    
    /**Metodo per simulare l'arrivo di una richiesta di Fallimento su un nodo che prende il Token.*/
    public void manageFailRequest(FailRequest r)
    throws IOException, InterruptedException, ClassNotFoundException
    {
        if(this.tokenManager!=null)this.tokenManager.stopTimeout();
        this.cm.sleep(99999999);
        this.sm.sleep(99999999);
        //this.cm.closeConnection();
    }
    
    /**Metodo per simulare l'arrivo di una richiesta di Insert*/
    public void receivedFailRequest(FailRequest fr)
    throws AttributeNotFoundException
    {
        this.codaFail.putInQueue(fr);                
    }
    
    
    public void simulaFailSenzaToken()
    throws IOException, InterruptedException, ClassNotFoundException
    {
        System.out.println("Nodo "+ this.getPort()+": CAAAAAAAAAADOOOOOOOOOOOOOOO");
        this.cm.suspend();
        this.sm.getServerThread().suspend();
        this.sm.suspend();
    }
}
