/*
 * CreationTokenManager.java
 *
 * Created on 15 aprile 2004, 21.20
 */

package Src.LogicaDistribuito;

/**
 *
 * @author  Monaco Luca
 */

import java.net.*;
import java.io.*;
import Src.Servizi.NetworkSupport.*;


/**Processo che si occupa di gestire la creazione del Token.*/
public class CreationTokenManager 
{
    
    /**Durata del timeout*/
    protected int t;
    
    
    protected int MINPRIORITY = 10000;
    
    protected NodoClassificatore node;
    
    protected boolean invalided;
    
    protected boolean ETSended;
    
    protected int priority;
    
    /**L' ELection TOken pi prioritario.*/
    protected  int mostPriority;
    
    protected TokenTimeout tt;
    
    /** Creates a new instance of CreationTokenManager */
    public CreationTokenManager(int t,NodoClassificatore n) {
        this.t=t;
        this.node=n;
        this.priority = n.getPort();
        this.invalided=false;
        this.ETSended=false;
        this.mostPriority = this.MINPRIORITY;
        this.tt = new TokenTimeout(this.t, this.node, this);
    }
    
    
    public void setInvalided(){
        this.invalided = true;
    }
    
    
    public boolean getETSended(){
        return this.ETSended;
    }
    
    public int getPriorit(){
        return this.priority;
    }
    
    public void resetMostPriority(){
        this.mostPriority=10000;
    }
    
    public void setTimeout(int t){
        this.t=t;
        this.tt.ferma();
        this.tt=new TokenTimeout(this.t,this.node,this);
    }
    
    public int getTokenTimeout(){
        return this.t;
    }
    
    /**Mi dice se il messaggio in ingresso  pi prioritario fra tutti quelli visti fin'ora.*/
    public boolean isMorePriority(int p)
    {
        if (p<this.mostPriority)return true;
        else return false;
    }
    
    
    public void resetTimeout(){
        this.tt.ferma();
        this.mostPriority = this.MINPRIORITY;
        this.tt=new TokenTimeout(this.t,this.node,this);
       
    }
    
    public void stopTimeout(){
        this.tt.ferma();
    }
    
    public void resetManager(){
        this.invalided=false;
        this.ETSended=false;
        this.resetTimeout();
    }
      
    /**Il metodo viene invocato quando scade il timeout.*/
    public void manageTimeout()
    throws InterruptedException, IOException, ClassNotFoundException
    {
        System.out.println("Nodo "+this.node.getPort()+": Il TokenTimeout  scaduto... Inizio il protocollo di elezione:");
        if (this.isMorePriority(this.priority)){
            System.out.println("Nodo "+this.node.getPort()+": Creato un ET di priorit: "+this.priority);
            ((ClientManagerClassificatore)this.node.getCm()).sendElectionTokenMessage();
            this.ETSended=true;
            this.mostPriority = this.priority;
        }
        else{
            System.out.println("Nodo "+this.node.getPort()+": Il nodo "+this.mostPriority+"  pi prioritario di me e ha gia creato un Token di elezione. --> ATTENDO pazientemente il token.");
            this.mostPriority = this.MINPRIORITY;
            this.tt=new TokenTimeout(this.t,this.node,this);
        }
    }
    
    
    public void manageElectionTokenMessage(ElectionTokenMessage m)
    throws InterruptedException,IOException, ClassNotFoundException
    {
        //this.restart();
        //this.resetMostPriority();
               
        if(m.getHeader().getfromPort()==this.node.getPort() && 
           m.getHeader().getfromAddr().equals(this.node.getAddress())){
            
                System.out.println("Nodo "+this.node.getPort()+": Ho ricevuto l'ET inviato da me.");
                if(invalided){ 
                    System.out.println("Nodo "+this.node.getPort()+": Mentre il mio ET era in giro ho ricevuto il token.");
                }
                else if (this.mostPriority==this.priority){ 
                    System.out.println("Nodo "+this.node.getPort()+": Genero il Token.");
                    this.node.manageTokenMessage(new TokenMessage(this.node.getAddress(),this.node.getPort(),"token"));
                    //sleep(5000);
                }
                else {
                    System.out.println("Nodo "+this.node.getPort()+": Mentre il mio ET era in giro ho ricevuto ET pi prioritari.");
                }
                this.ETSended=false;
                this.invalided=false;
                this.mostPriority=this.MINPRIORITY;
        }
        
        else if(this.node.hasToken()){
            System.out.println("Nodo "+this.node.getPort()+": Ho ricevuto l'ET inviato da "+m.getPriority());
            System.out.println("Nodo "+this.node.getPort()+": IO HO IL TOKEN! --> Scarto l'ET inviatomi.");
            return;
        } 
            
        else if(this.isMorePriority(m.getPriority())){
            System.out.println("Nodo "+this.node.getPort()+": Ho ricevuto l'ET inviato da "+m.getPriority());
            this.mostPriority = m.getPriority();
            System.out.println("Nodo "+this.node.getPort()+":  IL PIU PRIORITARIO ricevuto fin'ora. ");
            ((ClientManagerClassificatore)this.node.getCm()).passElectionTokenMessage(m);
            return;
        }
        
        else {
            System.out.println("Nodo "+this.node.getPort()+": Ho ricevuto l'ET inviato da "+m.getPriority());
            System.out.println("Nodo "+this.node.getPort()+": Il nodo "+this.mostPriority+" ha generato un ET pi prioritario --> LO SCARTO!.");
            return;
        } 
         
    }
}
