/*
 * ClientManagerClassificatore.java
 *
 * Created on 10 aprile 2004, 17.30
 */

package Src.LogicaDistribuito;

/**
 *
 * @author  Monaco Luca
 */
import Src.Servizi.NetworkSupport.*;
import Src.Servizi.Exception.*;
import java.net.*;
import java.io.*;
import Src.Logica.*;


public class ClientManagerClassificatore extends ClientManager
{
    
    protected Timeout timeout;
    
    
    /** Creates a new instance of ClientManagerClassificatore */
    public ClientManagerClassificatore() {
    }
    
    
    public ClientManagerClassificatore(InetAddress host, int port, NetworkNode node)
    throws IOException
    {
        super(host, port, (NodoClassificatore)node);
    }
    
    
    public Timeout getTimeout(){
        return this.timeout;
    }
    
    /**Il messaggio permette l'invio di un messaggio di Raccolta*/
    public void sendCollectMessage(ExampleSet content)
    throws InterruptedException, IOException
    {
        try{
             int t = 80000;
             CollectMessage cm = new CollectMessage(this.node.getAddress(),this.node.getPort(),"cccccccccccc "+this.node.getPort()+":COLLECT MESSAGE cccccccccccc",content);
             this.sendMessage(cm);
             this.timeout = new Timeout(t, ((NodoClassificatore)this.node), "collect");
        }
        catch(Exception e){
            System.out.println(e.getMessage());
        }
    }
    
    /**Il messaggio permette l'invio di un messaggio di Aggiornamento.*/
    public void sendUpdateMessage(ExampleSet content)
    throws InterruptedException, IOException
    {
        int t = 150000;
        UpdateMessage cm = new UpdateMessage(this.node.getAddress(),this.node.getPort(),"uuuuuuuuuuuu "+this.node.getPort()+":UPDATE MESSAGE uuuuuuuuuuuu",content);
        this.sendMessage(cm);
        this.timeout = new Timeout(t, ((NodoClassificatore)this.node), "update");
    }
    
    
    /**Il messaggio permette l'invio di un messaggio di Inizializzazione.*/
    public void sendInitializeMessage(TrainingSet content)
    throws InterruptedException, IOException
    {
        InitializeMessage im = new InitializeMessage(this.node.getAddress(),this.node.getPort(),"iiiiiiiiiiiiiiiiiiii  "+this.node.getPort()+":INITIALIZE MESSAGE  iiiiiiiiiiiiiiiiiiii",content);
        this.sendMessage(im);
    }
    
    
    /**Il messaggio permette l'invio del Token.*/
    public void sendTokenMessage()
    throws InterruptedException, IOException, ClassNotFoundException
    {
        int t = this.connection.getSoTimeout();            
        try{
            this.connection.setSoTimeout(8000);
        
            TokenMessage tm = new TokenMessage(this.node.getAddress(),this.node.getPort(),"*********************  "+this.node.getPort()+":INVIO DEL TOKEN  *********************");
            this.sendMessage(tm);
            this.receiveILiveMessage();
        }
        catch(SocketTimeoutException e){
            System.out.println("Nodo "+this.node.getPort()+": RILEVATA la caduta del nodo successivo.");
            ((NodoClassificatore)this.node).manageNodeFail();
        }
        this.connection.setSoTimeout(t);
    }
    
    
    /**Permette di ricevere un messaggio di ack dal nodo a cui vogliamo passrre il token.*/
    public void receiveILiveMessage()
    throws InterruptedException, IOException, ClassNotFoundException
    {
        ILiveMessage ret = (ILiveMessage)this.receiveMessage();
        ((NodoClassificatore)this.node).manageILiveMessage(ret);
    }
    
    /**Permette di inoltrare un messaggio di collect verso il successivo.*/
    public void passCollectMessage(CollectMessage msg,ExampleSet es)
    throws InterruptedException, IOException
    {
          CollectMessage m = new CollectMessage(msg.getHeader(),es);
          this.sendMessage(m);
    }
    
    /**Permette di inoltrare un messaggio di update verso il successivo.*/
    public void passUpdateMessage(UpdateMessage msg)
    throws InterruptedException, IOException
    {
          this.sendMessage(msg);
    }
    
    
    /**Il messaggio permette l'invio di un messaggio oer ucire dalla rete*/
    public void sendOffLineMessage(Address addr, boolean token)
    throws InterruptedException, IOException
    {
        OffLineMessage cm = new OffLineMessage(this.node.getAddress(),this.node.getPort(),"---------------------  "+this.node.getPort()+":offline MESSAGE  ---------------------",addr,token);
        this.sendMessage(cm);
    }
    
    /**Il messaggio permette l'invio di un messaggio di AreYouLive.*/
    public void sendAreYouLiveMessage(Address addr)
    throws InterruptedException, IOException, ClassNotFoundException
    {
        AreYouLiveMessage m = null;
        int t = this.connection.getSoTimeout();            
        try{
            this.connection.setSoTimeout(8000);
        
            m = new AreYouLiveMessage(this.node.getAddress(),this.node.getPort(),"???????????????????? "+this.node.getPort()+":AreYouLive MESSAGE ????????????????????",addr);
            this.sendMessage(m);
            this.receiveILiveMessage();
        }
        catch(SocketTimeoutException e){
            System.out.println("Nodo "+this.node.getPort()+": RILEVATA la caduta del mio nodo successivo.");
            ((NodoClassificatore)this.node).manageRecoveryRing(m);
        }
        this.connection.setSoTimeout(t);
    }
    
    /**Permette di inoltrare un messaggio di update verso il successivo.*/
    public void passAreYouLiveMessage(AreYouLiveMessage msg)
    throws InterruptedException, IOException, ClassNotFoundException
    {
        int t = this.connection.getSoTimeout();            
        try{
            this.connection.setSoTimeout(8000);
            this.sendMessage(msg,"???????????????????? "+msg.getHeader().getfromPort()+":AreYouLive MESSAGE ????????????????????");
            this.receiveILiveMessage();
        }
        catch(SocketTimeoutException e){
            System.out.println("Nodo "+this.node.getPort()+": RILEVATA la caduta del mio nodo successivo con la procedura AreYouLive.");
            ((NodoClassificatore)this.node).manageRecoveryRing(msg);
        }
        this.connection.setSoTimeout(t);
    }
    
    
           
    /**Permette di INVIARE un token di elezione verso il successivo.*/
    public void sendElectionTokenMessage()
    throws InterruptedException, IOException, ClassNotFoundException
    {
        int t = this.connection.getSoTimeout();  
        ElectionTokenMessage m = new ElectionTokenMessage(this.node.getAddress(),this.node.getPort(),"-----------  "+this.node.getPort()+":ELECTION TOKEN  -----------",null);
        try{
            this.connection.setSoTimeout(8000);
            this.sendMessage(m);
            this.receiveILiveMessage();
        }
        catch(SocketTimeoutException e){
            System.out.println("Nodo "+this.node.getPort()+": RILEVATA la caduta del nodo successivo nel passaggio dell'ELECTION TOKEN.");
            ((NodoClassificatore)this.node).manageRecoveryRing(m);
        }
        this.connection.setSoTimeout(t);
    }
        
    /**Permette di inoltrare un token di elezione verso il successivo.*/
    public void passElectionTokenMessage(ElectionTokenMessage msg)
    throws InterruptedException, IOException, ClassNotFoundException
    {
         int t = this.connection.getSoTimeout();            
         try{
            this.connection.setSoTimeout(8000);
            this.sendMessage(msg,"-----------  "+msg.getHeader().getfromPort()+":ELECTION TOKEN  -----------");
            this.receiveILiveMessage();
        }
        catch(SocketTimeoutException e){
            System.out.println("Nodo "+this.node.getPort()+": RILEVATA la caduta del nodo successivo nel passaggio dell'ELECTION TOKEN.");
            ((NodoClassificatore)this.node).manageRecoveryRing(msg);
        }
        this.connection.setSoTimeout(t);
    }
}
