/*
 * TrainigSet.java
 *
 * Created on 22 febbraio 2004, 2.34
 */

package Src.Logica;

/**
 *
 * @author  Monaco Luca
 */
import java.util.*;
import org.w3c.dom.*;
import Src.Servizi.Exception.*;
import Src.Servizi.ServiziXML.LibreriaDOM.*;
import Src.Servizi.NetworkSupport.*;
import javax.xml.parsers.*;
import org.xml.sax.SAXException;
import java.io.*;


/**La classe rappresenta una collezione di esempi, input del classificatore, che vengono usati per
 * l'elelaborazione del concetto, cio dell'albero decisionale.
 * A differenza della classe da cui ereditano un TrainingSet viene costruito a partire da un documento
 * XML.*/
public class TrainingSet extends ExampleSet implements XMLElement{
    
        
    public TrainingSet()
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        super();
    }
    
    /**Costruttore da elemento XML*/
    public TrainingSet(Element el)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        this.listaEsempi = new ArrayList();
        String nomeFile = LibreriaDOM.getValue(el,"dichiarazione");
        System.out.println(nomeFile);
        this.dichiarazione = new Dichiarazione(nomeFile);
        NodeList list = el.getElementsByTagName("esempio");
        for(int i=0;i<list.getLength();i++)
        {
            Element elemEs = (Element)list.item(i);
            Esempio es = new Esempio(elemEs,this);
            this.listaEsempi.add(es);
        }
    }
    
    public TrainingSet(ExampleSet es,Dichiarazione d )
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        for(int i=0;i<es.getSize();i++){
            this.addEsempio(es.getEsempio(i));
        }
        
        this.dichiarazione = d;
    }
    
    /**Per la trasformazione di un oggetto in un elemento XML*/
    public Element objToXml(Document doc)
    {
        Element elTs = doc.createElement("TrainingSet");
        for(int i=0;i<this.listaEsempi.size();i++)
        {
            Esempio es = (Esempio)this.listaEsempi.get(i);
            Element elEs= es.objToXml(doc);
            elTs.appendChild(elEs);
        }
        return elTs;
    }
    
    
    /**Per la trasformazione di un element in un oggetto*/
    public XMLElement xmlToObj(Element el)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        return new TrainingSet(el);
    }
    
}

