/*
 * Istanza.java
 *
 * Created on 19 febbraio 2004, 21.04
 */

package Src.Logica;

/**
 *
 * @author  Monaco Luca
 */
import Src.Servizi.Exception.*;
import Src.Servizi.ServiziXML.LibreriaDOM.*;
import java.util.*;
import org.w3c.dom.*;
import Src.Logica.*;
import javax.xml.parsers.*;
import org.xml.sax.SAXException;
import java.io.*;

public class Istanza implements XMLElement,Serializable
{
    
    private ArrayList listaAttributi;
    
    private Dichiarazione dichiarazione;
    
    
    /** Creates a new instance of Istanza */
    public Istanza()
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        this.listaAttributi = new ArrayList();
        this.dichiarazione = new Dichiarazione();
    } 
    
    /**Costruttore a partire dalla lista di Attributi*/
    public Istanza(ArrayList list)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        this.listaAttributi = list;
        this.dichiarazione= new Dichiarazione();
    } 
   
    public Istanza(Element el,Dichiarazione d)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        this.listaAttributi = new ArrayList();
        this.dichiarazione = d;
        int nAttributi = this.dichiarazione.getNumAttributi();
        for (int i=0;i<nAttributi;i++){
            String nome = dichiarazione.getNomeAttributo(i);
            String tipo = dichiarazione.getTipoAttributo(nome);
            
            if(tipo.equals("continuo")) 
                this.addAttributo(new AttributoContinuo(nome,new Integer(LibreriaDOM.getValue(el,nome)).intValue()));
            else {
                String value = LibreriaDOM.getValue(el,nome);
                if (dichiarazione.checkValoreAttributo(nome,value))
                    this.addAttributo(new AttributoDiscreto(nome, value));
                    
                else System.out.println("Costruttore Istanza(el): Il valore da assegnare all'attributo discreto non  valido: "+value);
            }
        }
    }
    
    /**Permette il recupero della lista dei prodotti.*/
    public ArrayList getListaAttributi()
    {
        return this.listaAttributi;
    }
    
    /**Metodo per recuperare l'attributo posizionato in un certo punto della lista
     *@param index - Indice della lista dal quale prelevare l'elemento.*/
    public Attributo getAttributo(int index) 
    throws IndexOutOfBoundsException
    {
        return (Attributo)this.listaAttributi.get(index);
    }
    
    
    /**Metodo per recuperare all'interno dell'istanza l'attributo con un certo nome.
     @param name Il nome dell'attributo cercato.*/
    public Attributo getAttributo(String name)
    throws AttributeNotFoundException
    {
        for(int i=0;i<this.getSize();i++)
        {
            Attributo attr = this.getAttributo(i);
            if (attr.getNome().equals(name)) return attr; 
        }
        throw new AttributeNotFoundException("Non esiste un attributo chiamato "+name+" nell'istanza.");
    }
    
    
    /**Metodo per aggiungere in coda alla lista un elemento.
     *@param p - Il prodotto che si vuol aggiungere in coda.
     *@return - La posizione nella lista in cui l'elemento  stato aggiunto.*/
    public void addAttributo(Attributo attr)
    {
       this.listaAttributi.add(attr);
    }
    
    
    /**Metodo per calcolare il numero di attributi che costituiscono l'istanza.*/
    public int getSize()
    {
       return this.listaAttributi.size();
    }
   
    
    /**Per la trasformazione di un oggetto in un elemento XML*/
    public Element objToXml(Document doc)
    
    {
        Element elIst = doc.createElement("istanza");
        for(int i=0;i<this.getSize();i++)
        {
            Attributo attr = this.getAttributo(i);
            Element elAttr = attr.objToXml(doc);
            elIst.appendChild(elAttr);
        }
        return elIst;
    }
    
    /**Per la trasformazione di un element in un oggetto*/
    public XMLElement xmlToObj(Element el)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        return new Istanza(el,this.dichiarazione);
    }
    
        
    public String toString()
    {
        String s="";
        for(int i=0;i<this.getSize();i++)
        {
            Attributo attr = this.getAttributo(i);
            if (attr.getTipo().equals("continuo"))
                s+= "  "+((AttributoContinuo)attr).getValue();
            else s+="  "+((AttributoDiscreto)attr).getValue();
        }
        return s;
    }
}
