/*
 * FogliaAD.java
 *
 * Created on 1 marzo 2004, 13.08
 */

package Src.Logica;

/**
 *
 * @author  Monaco Luca
 */
import java.util.*;


public class FogliaAD implements Nodo
{
    
    private NodoAD padre;
    
    private int altezzaNodo;
    
    private String classe;
    
    private String nome;
    
    
    /** Creates a new instance of FogliaAD */
    public FogliaAD(NodoAD p, String c,String nome) 
    {
        this.padre = p;
        this.classe = c;
        this.altezzaNodo = p.getAltezzaNodo()+1;
        this.nome=nome;
        p.getAlbero().addNodoFoglia(this);
        
        //System.out.println("********************Creato un nodo folgia... classe:"+c.toUpperCase()+"    altezza del nodo: "+this.altezzaNodo);
    }
    
    
    public String getNome()
    {
        return this.nome;
    }
    
    public String valuta(Istanza i)
    {
        return this.classe;
    }
    
    public String getClasse()
    {
        return this.classe;
    }
    
    public int getAltezzaNodo() 
    {
        return this.altezzaNodo;
    }
    
    /**Permette di calcolare il cammino tra la radice dell'albero e il nodo.*/
    public ArrayList getPath()
    {
         ArrayList list = new ArrayList(this.padre.getPath());
         list.add(this.nome);
         return list;
    } 
    
    
     public String toString()
    {
       return ""+ this.getPath()+"   CLASSE:"+this.classe+"   livello: "+this.getAltezzaNodo();
    }
}
