/*
 * ExampleSet.java
 *
 * Created on 28 febbraio 2004, 9.19
 */

package Src.Logica;

/**
 *
 * @author  Monaco Luca
 */
import java.util.*;
import Src.Servizi.Exception.*;
import Src.Servizi.ServiziXML.LibreriaDOM.*;
import Src.Servizi.NetworkSupport.*;
import javax.xml.parsers.*;
import org.xml.sax.SAXException;
import java.io.*;

/**La classe rappresenta un insieme di esempi che possono essere dati in ingresso a un nodo di un albero
 * decisionale.*/
public class ExampleSet implements MessageContent
{
    
    protected ArrayList listaEsempi;
    
    protected Dichiarazione dichiarazione;
    
    /** Creates a new instance of TrainigSet */
    public ExampleSet()
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        this.listaEsempi = new ArrayList();
        this.dichiarazione = new Dichiarazione();
    }
    
    /**Costruttore per copia.*/
    public ExampleSet(ArrayList l) 
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        listaEsempi = new ArrayList(l);
        this.dichiarazione = new Dichiarazione();
    }
    
    
    public Esempio getEsempio(int index)
    {
        return (Esempio)this.listaEsempi.get(index);
    }
    
    
    public void addEsempio(Esempio es)
    {
        this.listaEsempi.add(es);
    }
    
    
    /**Per la rimozione di un esempio.
     *@return L'esempio rimosso.*/
    public Esempio removeEsempio(int index)
    {
        return (Esempio)this.listaEsempi.remove(index);
    }
    
    
    public int getSize()
    {
        return this.listaEsempi.size();
    }
    
    public Dichiarazione getDichiarazione()
    {
        return this.dichiarazione;
    }
    
    
    public String toString()
    {
        String ret="";
        for(int i=0;i<this.getSize();i++){
            ret += this.getEsempio(i).getIstanza() +" ";
            ret += this.getEsempio(i).getClasse() +"\n";
        } 
        return ret;
    }
}
