/*
 * TrainingSet.java
 *
 * Created on 20 febbraio 2004, 18.54
 */

package Src.Logica;

/**
 *
 * @author  Monaco Luca
 */
import java.util.*;
import org.w3c.dom.*;
import Src.Servizi.Exception.*;
import Src.Servizi.ServiziXML.LibreriaDOM.*;
import javax.xml.parsers.*;
import org.xml.sax.SAXException;
import java.io.*;


/**La classe rappresenta un Esempio, cio un Istanza alla quale  associata una classe di appartenenza.*/
public class Esempio implements XMLElement,Serializable{
    
    /**Descrizione dell'oggetto di esempio in termini di coppie attributo-valore.*/
    private Istanza istanza;
    
    /**Classe a cui l'esempio appartiene.*/
    private String classe;
    
    /**Riferimento al trainingSet di cui fai parte l'esempio*/
    private TrainingSet ts;
    
    /**Costruttore per passaggio dei paramentri.*/
    public Esempio(TrainingSet ts,Istanza is, String cl)
    {
        this.ts = ts;
        this.istanza = is;
        this.classe = cl;
    }
    
    /**Costruttore per passaggio di un elemento XML <esempio>*/
    public Esempio(Element el,TrainingSet ts)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        this.ts = ts;
        NodeList lista = el.getElementsByTagName("class");
        this.classe = LibreriaDOM.getValue(el, "class");
        NodeList list = el.getElementsByTagName("istanza");
        Element es = (Element)list.item(0);
        this.istanza = new Istanza(es,this.ts.getDichiarazione());
        
    }
    
    /**Restituisce la classe dell'esempio.*/
    public String getClasse()
    {
        return this.classe;
    }
    
    /**Restituisce l'istanza associata all'esempio.*/
    public Istanza getIstanza()
    {
        return this.istanza;
    }
    
    
    /**Per la trasformazione di un oggetto in un elemento XML*/
    public Element objToXml(Document doc)
    {
        Element elEs = doc.createElement("esempio");
        Element elIs = this.istanza.objToXml(doc);
        Element elCl = LibreriaDOM.createTextElement(doc, "classe", this.classe,false);
        elEs.appendChild(elIs);
        elEs.appendChild(elCl);
        return elEs;
    }
    
    /**Per la trasformazione di un element in un oggetto*/
    public XMLElement xmlToObj(Element el)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        return new Esempio(el,this.ts);
    }
    
    
    
    public String toString()
    {
        return this.istanza.toString()+"     "+this.classe;
    }
   
}
