/*
 * Descrizione.java
 *
 * Created on 24 febbraio 2004, 22.31
 */

package Src.Logica;

/**
 *
 * @author  Monaco Luca
 */
import org.w3c.dom.*;
import java.util.*;
import Src.Servizi.ServiziXML.LibreriaDOM.*;
import javax.xml.parsers.*;
import org.xml.sax.SAXException;
import java.io.*;

/**Questa classe fornisce la descrizione delle caratteristiche di un esempio. Infatti, possiamo 
 * dividere la conoscenza fornita inizialmente in due parti:
 * La prima mi permette di dichiarare il nome, il tipo e altre propriet che avranno gli attributi 
 * di un istanza, e di dichiarare il nome delle classi a cui un esempio pu appartenere.
 * La seconda  l'effettivo insieme di esempi.
 * E' necessario fare questa distinzione per non legarci alla risoluzione di uno specifico dominio di
 * apprendimento. Infatti nelle definizioni delle Classi Esempio, Istanza, ecc. non abbiamo riportato 
 * esplicitamente le caratteristiche degli oggetti, perch queste cambiano al variare del concetto da 
 * apprendere.
 * La descrizione della conoscenza che in questa classe vogliamo rappresentare, viene estrapolata
 * dal parsing di un file XML.*/
public class Dichiarazione implements Serializable
{
    
    /**Nome del file XML in cui  riportata la descrizione della conoscenza.
     * Il valore assegnato  di default.*/
    private String NOMEFILE = "c:/progetti/Classificatore/Dichiarazione.xml";
    
       
    /**Lista degli attributi di una istanza.*/
    private ArrayList listaAttributi;
    
    /**Lista delle classi a cui gli esempi possono appartenere.*/
    private ArrayList listaClassi;
    
    public Dichiarazione()
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        Document doc = LibreriaDOM.loadDocument(this.NOMEFILE);
        this.listaAttributi = new ArrayList();
        this.listaClassi = new ArrayList();
        NodeList listAttr = doc.getElementsByTagName("attributo");
        for(int i=0;i<listAttr.getLength();i++){
            Element el = (Element)listAttr.item(i);
            String tipo = el.getAttribute("tipo");
            String nome = LibreriaDOM.getValue(el, "nome");
            if (tipo.equals("continuo")) {
                int soglia = new Integer(LibreriaDOM.getValue(el,"soglia")).intValue();
                DescrizioneAttributoContinuo ac = new DescrizioneAttributoContinuo(nome, soglia);
                this.listaAttributi.add(ac);
            }
            else{
                NodeList listaVal = el.getElementsByTagName("val");
                ArrayList valori = new ArrayList();
                for(int j=0;j<listaVal.getLength();j++){
                   valori.add(LibreriaDOM.getValue(el, "val",j));
                }
                DescrizioneAttributoDiscreto ad = new DescrizioneAttributoDiscreto(nome,valori);
                this.listaAttributi.add(ad);
            }
        }
        int nClassi = LibreriaDOM.getSize(doc, "classe");
        for (int k=0;k<nClassi;k++)
            this.listaClassi.add(LibreriaDOM.getValue(LibreriaDOM.getElement(doc,"classe",k)));
        
    }    
    
    /** Creates a new instance of Descrizione */
    public Dichiarazione(String nomeFile)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        this.NOMEFILE = nomeFile;
        Document doc = LibreriaDOM.loadDocument(this.NOMEFILE);
        this.listaAttributi = new ArrayList();
        this.listaClassi = new ArrayList();
        NodeList listAttr = doc.getElementsByTagName("attributo");
        for(int i=0;i<listAttr.getLength();i++){
            Element el = (Element)listAttr.item(i);
            String tipo = el.getAttribute("tipo");
            String nome = LibreriaDOM.getValue(el, "nome");
            if (tipo.equals("continuo")) {
                int soglia = new Integer(LibreriaDOM.getValue(el,"soglia")).intValue();
                DescrizioneAttributoContinuo ac = new DescrizioneAttributoContinuo(nome, soglia);
                this.listaAttributi.add(ac);
            }
            else{
                NodeList listaVal = el.getElementsByTagName("val");
                ArrayList valori = new ArrayList();
                for(int j=0;j<listaVal.getLength();j++){
                   valori.add(LibreriaDOM.getValue(el, "val",j));
                }
                DescrizioneAttributoDiscreto ad = new DescrizioneAttributoDiscreto(nome,valori);
                this.listaAttributi.add(ad);
            }
        }
        int nClassi = LibreriaDOM.getSize(doc, "classe");
        for (int k=0;k<nClassi;k++)
            this.listaClassi.add(LibreriaDOM.getValue(LibreriaDOM.getElement(doc,"classe",k)));
        
    }
    
    
    /*public Dichiarazione(String nomefile)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        //this.NOMEFILE = nomefile;
        new Dichiarazione();
    }*/
    
    /**Per recuperare il tipo di un attributo a partire dal suo nome.*/
    public String getTipoAttributo(String nome)
    {
        for(int i=0;i<this.listaAttributi.size();i++){
            Attributo attr = (Attributo) this.listaAttributi.get(i);
            if (attr.getNome().equals(nome)) return attr.getTipo();
        }
        System.out.println("Errore Descrizione.getTipoAttributo(): nome attributo cercato errato!");
        return null;
    }
    
    
    /**Per recuperare il valore soglia di un attributo continuo*/
    public int getSogliaAttributoContinuo(String nome)
    {
        for(int i=0;i<this.listaAttributi.size();i++){
            Attributo attr = (Attributo) this.listaAttributi.get(i);
            if (attr.getNome().equals(nome)){
                if(attr.getTipo().equals("continuo")) return ((DescrizioneAttributoContinuo)attr).getSoglia();
                else System.out.println("Errore Descrizione.getSogliaAttributoContinuo(): L'attributo non  continuo!");
            }
        }
        System.out.println("Errore Descrizione.getSogliaAttributoContinuo(): nome attributo cercato errato!");
        return -1;
    }
    
    /**Per recuperare i vaolori possibili di un certo attributo dicreto*/
    public ArrayList getValoriPossibiliAttributoDiscreto(String nome)
    {
        for(int i=0;i<this.listaAttributi.size();i++){
            Attributo attr = (Attributo) this.listaAttributi.get(i);
            if (attr.getNome().equals(nome)){
                if(attr.getTipo().equals("discreto")) return ((DescrizioneAttributoDiscreto)attr).getValori();
                else System.out.println("Errore Descrizione.getValoriPossibiliAttributoDiscreto(): L'attributo non  discreto!");
            }
        }
        System.out.println("Errore Descrizione.getValoriPossibiliAttributoDiscreto(): nome attributo cercato errato!");
        return null; 
    }
    
    /**Per recuoerare il nome delle classi a cui un esempio pu appartenere.*/
    public ArrayList getNomeClassi()
    {
        return new ArrayList(this.listaClassi);
    }
    
    
    /**Per recuperare il numero di valori che un certo attributo pu assumere*/
    public int getNumValoriAttributoDiscreto(String nome)
    {
        for(int i=0;i<this.listaAttributi.size();i++){
            Attributo attr = (Attributo) this.listaAttributi.get(i);
            if (attr.getNome().equals(nome)){
                if(attr.getTipo().equals("dicreto")) return ((DescrizioneAttributoDiscreto)attr).getNumValori();
                else System.out.println("Errore Descrizione.getNumValoriAttributoDiscreto(): L'attributo non  discreto!");
            }
        }
        System.out.println("Errore Descrizione.getNumValoriAttributoDiscreto(): nome attributo cercato errato!");
        return -1;
    }
    
    public String getNomeAttributo(int i)
    {
        return ((Attributo)this.listaAttributi.get(i)).getNome();
    }
    
    public ArrayList getListaAttributi()
    {
        return new ArrayList(this.listaAttributi);
    }
    
    
    public int getNumAttributi()
    {
        return this.listaAttributi.size();
    }
    
    public int getNumClassi()
    {
        return this.listaClassi.size();
    }
    
    /**Recupera la lista dei nome degli attributi di cui un istanza  composta.*/
    public ArrayList getNomeAttributi()
    {
        ArrayList ris = new ArrayList();
        for(int i=0;i<this.getNumAttributi();i++)
            ris.add(this.getNomeAttributo(i));
        return ris;
    }
    
    /**Verifica che l'attributo possa assumere un certo valore*/
    public boolean checkValoreAttributo(String nome,String val)
    {
        for(int i=0;i<this.listaAttributi.size();i++){
            Attributo attr = (Attributo) this.listaAttributi.get(i);
            if (attr.getNome().equals(nome)) return ((DescrizioneAttributoDiscreto)attr).checkValue(val);
        }
        return false;    
    }
    
    /**Verifica l'esistenza di una classe*/
    public boolean checkClasse(String nome)
    {
        for(int i=0;i<this.listaClassi.size();i++){
            String attr = (String) this.listaClassi.get(i);
            if (attr.equals(nome)) return true;
        }
        return false;    
    }
    
    public String toString()
    {
        String s="";
        for(int i=0;i<this.listaAttributi.size();i++)
        {
            Attributo attr = (Attributo)this.listaAttributi.get(i);
            if (attr.getTipo().equals("continuo")) s+=((DescrizioneAttributoContinuo)attr).toString()+"\n";
            else s+=((DescrizioneAttributoDiscreto)attr).toString()+"\n";
        }
        return s;
    }
}
