/*
 * DescrizioneAttributoDiscreto.java
 *
 * Created on 26 febbraio 2004, 20.29
 */

package Src.Logica;

/**
 *
 * @author  Monaco Luca
 */

import java.util.*;
import org.w3c.dom.*;

public class DescrizioneAttributoDiscreto extends Attributo {
    
    private ArrayList valori;
    
    /** Creates a new instance of DescrizioneAttributoDiscreto */
    public DescrizioneAttributoDiscreto(String nome, ArrayList valori)
    {
        this.valori = new ArrayList(valori);
        this.nome= nome;
        this.tipo="discreto";
    }
    
    public int getNumValori()
    {
        return this.valori.size();
    }
    
    public String getValore(int index)
    {
        return (String)this.valori.get(index);
    }
    
    public ArrayList getValori()
    {
        return new ArrayList(this.valori);
    }
    
    
    
    
    public boolean checkValue(String value)
    {
        for(int i=0;i<valori.size();i++)
            if (((String)valori.get(i)).equals(value)) return true;
        return false;
    }
    
    public Element objToXml(Document doc)
    {
        return null;
    }
    
    
    public String toString()
    {
        String s="";
        s += this.nome+":    tipo: Discreto"+ "   valori: ";
        for (int i=0;i<this.valori.size();i++)  s+=""+this.getValore(i)+" ";
        return s;
    }
}
