/*
 * Classificatore.java
 *
 * Created on 4 marzo 2004, 22.15
 */

package Src.Logica;

/**
 *
 * @author  Monaco Luca
 */
import Src.Logica.*;
import Src.Servizi.ServiziXML.LibreriaDOM.*;
import org.xml.sax.SAXException;
import javax.xml.parsers.*;
import org.apache.xml.serialize.*;
import Src.Servizi.Exception.*;
import java.io.*;
import java.util.*;

public class Classificatore {
    
    private TrainingSet ts;
        
    private AlberoDecisionale albero;
    
    private ExampleSet testingSet;
    
   
    
    public TrainingSet getTrainingSet()
    {
        return this.ts;
    }
    
    public ExampleSet getTestingSet()
    {
        return this.testingSet;
    }
    
    /** Creates a new instance of Classificatore */
    public Classificatore(String nomeFile)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException,ElementNotFoundException, AttributeNotFoundException
    {
        this.ts = this.caricaTrainingSet(nomeFile);
        
        new Classificatore(this.ts);
    }
    
    
    public Classificatore(TrainingSet ts)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException
    {
        this.albero = new AlberoDecisionale(ts);
        //System.out.println("");
        //System.out.println("Albero decisionale creato con successo!");
        //System.out.println(this.albero);
        
        this.testingSet = new ExampleSet();
    }
    
    /**Permette di caricare il TrainingSet dal file XML.*/
    public TrainingSet caricaTrainingSet(String nomeFile)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException,ElementNotFoundException, AttributeNotFoundException
    {
        if (nomeFile==null) nomeFile="c:/progetti/Classificatore/TrainingSet.xml";
        DocumentHandler dh = new DocumentHandler(nomeFile);
        return ts  =(TrainingSet)dh.loadElementFromXML("elenco","id","1");
    }
    
    
    /**Permette di classificare un'istanza data in ingresso.*/
    public String classifica(Istanza i)
    throws AttributeNotFoundException
    {        
        return this.albero.valuta(i);
    }
    
    
    /**Permette di verificare se un Esempio dato ingresso  coperto dal classificatore.*/
    public boolean isCovered(Esempio es)
    throws AttributeNotFoundException
    {
        Istanza ist = es.getIstanza();
        String classeAssociata = this.classifica(ist);
        if (classeAssociata.equals(es.getClasse()))
            return true;
        return false;
    }
    
    
    /**Permette di verificare se il Classificatore  corretto.*/
    public boolean isCorrect()
    throws AttributeNotFoundException
    {
        for(int i=0;i<this.ts.getSize();i++){
            Esempio es = this.ts.getEsempio(i);
            if (!this.isCovered(es)) return false;
        }
        return true;
    }
    
    
    /**Funzione che permette la suddivisione del trainingSet iniziale, per creare un Testing Set.
     *@param dim Numero di Esempi del TrainingSet che verranno usati per formare il TestingSet.*/
    public void creaTestingSet(int dim)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException
    {
        System.out.println("Creazione del TestingSet:");
        this.testingSet = new ExampleSet();
     
        
        Random random = new Random();
        for(int i=0;i<dim;i++){
            int n = random.nextInt(this.ts.getSize()-1);
            System.out.println("Prelievo dell "+i+"-esimo elemeto... Indice:"+n);
            System.out.println("Dimensione attuale TrainingSet:"+this.ts.getSize());
            Esempio es = this.ts.removeEsempio(n);
            this.testingSet.addEsempio(es);
            System.out.println("Dimensione attuale TestingSet:"+this.testingSet.getSize());
        }        
             
         
        //Creo il nuovo albero considerano il nuovo TrainigSet.
        this.albero = new AlberoDecisionale(this.ts);
        
        
        System.out.println("");
        System.out.println("Testing Set generato (dimensione "+dim+"):");
        for(int i=0;i<testingSet.getSize();i++){
            System.out.print(this.testingSet.getEsempio(i).getIstanza() +" ");
            System.out.println(this.testingSet.getEsempio(i).getClasse());
        }
        System.out.println("");
        System.out.println("TrainingSet:");
        for(int i=0;i<ts.getSize();i++){
            System.out.print(this.ts.getEsempio(i).getIstanza() +" ");
            System.out.println(this.ts.getEsempio(i).getClasse());
        }
    }
    
    
    public AlberoDecisionale getAlbero()
    {        
        return this.albero;
    }
    
    /**Per la valutazione della percetuale di errori effettuati sul TestingSet*/
    public String valutaErroreSulTestingSet()
    throws AttributeNotFoundException
    {
        int esatti = 0;
        int errati = 0;
        if(this.testingSet.getSize()==0) return "0.0%";
        for (int i=0;i<this.testingSet.getSize();i++){
            Esempio es = this.testingSet.getEsempio(i);
            Istanza ist = es.getIstanza();
            String classeIst = this.classifica(ist);
            if (classeIst.equals(es.getClasse())){
                System.out.println("++++++++++++++OK. ESEMPIO CLASSIFICATO CORRETTAMENTE:   "+es);
                esatti++;
            }
            else {
                System.out.println("---------------CLASSIFICAZIONE ERRATA: "+es+" stato classificato "+classeIst);
                errati++;
            }
        }
        return ""+(float)errati/((float)errati+esatti)*100+"%";
    }
    
}
       