/*
 * AlberoDecisionale.java
 *
 * Created on 1 marzo 2004, 14.41
 */

package Src.Logica;

/**
 *
 * @author  Monaco Luca
 */
import java.util.*;
import Src.Servizi.Exception.*;
import javax.xml.parsers.*;
import org.xml.sax.SAXException;
import java.io.*;


public class AlberoDecisionale {
    
    /**Riferimento al nodo radice dell'albero.*/
    NodoAD nodoRadice;
    
    /**Riferimento al TrainingSet.*/
    TrainingSet ts;
    
    /**Riferimento alla Dichiarazione degli attributi delle istanze.*/
    Dichiarazione dichiarazione;
    
    /**Lista dei nodi folgia.*/
    ArrayList nodiFoglia;    
    
    
    /** Creates a new instance of AlberoDecisionale */
    public AlberoDecisionale(TrainingSet ts) 
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException
    {
        this.ts = ts;
        this.dichiarazione = ts.getDichiarazione();
        this.nodiFoglia = new ArrayList();
        this.nodoRadice = new NodoAD(this,this.ts,this.dichiarazione,0);
        
    }
    
    
    /**Per recuperare i nodi foglia dell'albero.*/
    public ArrayList getNodiFoglia()
    {
        return this.nodiFoglia;
    }
       
    
 
    
    /**Il metodo permette a un nodo dell'albero di scegliere l'attributo da utilizzare
     * per effettuare, e il test su un'istanza, e la partizione in fase di creazione dell'albero.
     * Notiamo che la selezione dell'attributo dipende dall'insieme di esempi in ingresso.
     *@param esempiRaggruppati Lista di ExampleSetOmogeno che contiene tanti elementi quanti
     * sono i gruppi in cui l'insieme di esempi  stato raggruppato.*/
    public String selezionaAttributo(NodoAD nodo)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException,AttributeNotFoundException
    {
        ExampleSet eSet = nodo.getEsempi();
        ArrayList attributiDisponibili = nodo.getAttributiDisponibili();
        
        if(attributiDisponibili.size()==1) return (String)attributiDisponibili.get(0);
        
        double infoIn = this.calcolaEntropia(eSet);
        
        double[] infoAttr = new double[attributiDisponibili.size()];
        
        double guadagnoMax = -1;
        String ris ="";
        
        for(int i=0;i<attributiDisponibili.size();i++){
            String nomeAttr = (String)attributiDisponibili.get(i);
            //System.out.println("###Partiziono secondo l'attributo: "+nomeAttr);
            ExampleSet[] esempiPartizionati = this.applicaPartizionamento(eSet,nomeAttr);
            //System.out.println("###FINE Partizionamento secondo l'attributo: "+nomeAttr);
            //System.out.println("###Ci sono "+esempiPartizionati.length+" partizioni: ");
           
            //System.out.println("###Calcolo dell'entropia dopo il partizionamento sull'attributo "+nomeAttr);
            infoAttr[i] = this.calcolaEntropiaExampleSetPartizionato(esempiPartizionati,nomeAttr);
            //System.out.println("###Entropia sull'attributo: "+nomeAttr+" = "+infoAttr[i]);
            double guadagno = infoIn-infoAttr[i];
            //System.out.println("###Guadagno utilizzando l'attributo "+nomeAttr+"="+guadagno);
            if (guadagno>guadagnoMax){ 
                guadagnoMax=guadagno;
                ris=nomeAttr;
                //System.out.println("###"+nomeAttr.toUpperCase()+"ha fino ad ora guadagno migliore");
            }
        }
         
        return ris;
    }
    
    
    /**Partiziona l'insieme degli esempi in ingresso al nodo fra i suoi nodi figli, in base al
     * valore assunto dall'attributo specificato.
     * Ritorna il numero di partizioni effettuate.*/
    public ExampleSet[] applicaPartizionamento(ExampleSet eSet,String nomeAttr)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException,AttributeNotFoundException
    {
        //Nella variabile gruppiPartizionati verranno memorizzati le partizioni degli esempi che
        //dovranno essere fatte considerando l'atributo passato.
        ExampleSet[] gruppiPartizionati;
        
        //Recupero il tipo dell'Attributo usato per effettuare la partizione.
        String tipoAttr = this.dichiarazione.getTipoAttributo(nomeAttr);
        if (tipoAttr.equals("discreto"))
        {
            //Se  discreto:
            //- Recupero i valori possibili che esso pu assumere (dalla dichiarazione).
            //  Se questo numero  N, allora il nodo deve avere N figli.
            ArrayList valori = this.dichiarazione.getValoriPossibiliAttributoDiscreto(nomeAttr);
            gruppiPartizionati = new ExampleSet[valori.size()];
            for (int i=0;i<gruppiPartizionati.length;i++) gruppiPartizionati[i]=new ExampleSet();
            //- Per ogni esempio:
            for (int i=0;i<eSet.getSize();i++)
            {
                Esempio es = eSet.getEsempio(i);
                //-- Recupero il valore dell'attributo passato per lo specifico esempio considerato.
                String valAttr = ((AttributoDiscreto)(es.getIstanza().getAttributo(nomeAttr))).getValue();
                //-- Partiziono gli esempi in base al valore dell'attributo:
                for(int j=0;j<valori.size();j++){
                    if(valAttr.equals((String)valori.get(j))){
                        gruppiPartizionati[j].addEsempio(es); 
                        break;
                    }
                }
            }
        }
        else{
            //Se  continuo:
            //- I numero dei figli del nodo sar 2: uno per gli esempi con un valore sotto la soglia,
            //  l'altro per gli esempi con valore sopra.
            gruppiPartizionati = new ExampleSet[2];
            for(int i=0;i<2;i++) gruppiPartizionati[i]=new ExampleSet();
            
            //- Recupero la soglia (dalla dichiarazione per ipotesi semplificativa);
            int soglia = this.dichiarazione.getSogliaAttributoContinuo(nomeAttr);
            
            //- Per ogni esempio  controllo il valore assunto dall'attributo e assegno l'esempio al gruppo opportuno.
            for (int i=0;i<eSet.getSize();i++){
                Esempio es = eSet.getEsempio(i);
                int valore = ((AttributoContinuo)(es.getIstanza().getAttributo(nomeAttr))).getValue();
                if (valore<=soglia){
                    gruppiPartizionati[0].addEsempio(es);
                }
                else{
                    gruppiPartizionati[1].addEsempio(es);
                }
            }
        }
        
        return gruppiPartizionati;
    }
    
    
    /**Il metodo ha il compito di calcolare l'etropia dopo il partizionameto effettutato secondo
     * un attributo dalla funzione applicaPartizionamento
     *@param esempiPartizionati Array che contine gli esempi Partizionati per valore assunto dall funzione*/
    public double calcolaEntropiaExampleSetPartizionato(ExampleSet[] esempiPartizionati,String nomeAttr)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException
    {
        //Recupero dei valori che l'attributo considerato pu assumere.
        ArrayList valori;
        String tipoAttr = this.dichiarazione.getTipoAttributo(nomeAttr);
        ArrayList valoriContinui = new ArrayList();
        valoriContinui.add("inf");
        valoriContinui.add("sup");
        
        if ( tipoAttr.equals("discreto"))
            valori = new ArrayList(this.dichiarazione.getValoriPossibiliAttributoDiscreto(nomeAttr));
        else valori = new ArrayList(valoriContinui);
         
        double[] info = new double[valori.size()];
        for(int i=0;i<info.length;i++) info[i]=0;
        
        //Per ogni valore che l'attributo pu assumere:
        for(int i=0;i<valori.size();i++)
        {
            String valoreAttuale = (String)valori.get(i);
            //- Ho una partizione per ogni valore che l'attributo pu assumere,
            //  Partizione corrente:
            ExampleSet partizione = esempiPartizionati[i];
          
            //- Creo e inizializzo a 0 un array che conterr il numero di esempi appartenti alle varie
            //  classi.
            int[] cardClassiNellaPart = new int[this.dichiarazione.getNumClassi()];
            for (int h=0;h<cardClassiNellaPart.length;h++) cardClassiNellaPart[h]=0;
            
            ArrayList nomeClassi = this.dichiarazione.getNomeClassi();
            
            //- Per ogni esempio della partizione:
            for(int j=0;j<partizione.getSize();j++){
                
                Esempio es = partizione.getEsempio(j);
                //- Trovo il valore che assume l'attributo nell'esempio in considerazione.
                String esVal;
                if (tipoAttr.equals("discreto")){
                     esVal = ((AttributoDiscreto)es.getIstanza().getAttributo(nomeAttr)).getValue();
                }
                else {
                    int val = new Integer(((AttributoContinuo)es.getIstanza().getAttributo(nomeAttr)).getValue()).intValue();
                    int valSoglia = this.dichiarazione.getSogliaAttributoContinuo(nomeAttr);
                    if (val<=valSoglia) esVal="inf";
                    else esVal="sup";
                }
                
                //- Se il valore che assume l'attributo  uguale a quello che sto considerando, 
                //  considero la sua classe e incremento il relativo contatore.
               // if (valoreAttuale.equals(esVal))
                    for(int k=0;k<nomeClassi.size();k++){
                        String classeCons = (String)this.dichiarazione.getNomeClassi().get(k);
                       if (es.getClasse().equals(classeCons)){ 
                            cardClassiNellaPart[k]++;
                            break;
                        }
                    }
            }
            
            
            //Calcolo dell'informazione della partizione:
            double entropiaPart = this.calcolaEntropia(partizione);
            info[i] = entropiaPart;
       }
        
        double ris = 0.0;
        double nTot = 0;
        for(int q=0;q<esempiPartizionati.length;q++) nTot += esempiPartizionati[q].getSize();
        for(int q=0;q<esempiPartizionati.length;q++){ 
            double fraz = esempiPartizionati[q].getSize()/nTot;
            ris += esempiPartizionati[q].getSize()/nTot * info[q];
        }
                 
        return ris;
    }
    
    
    
    /**La funzione raggruppa un insieme di esempi in Oggetti ExempleSet omogenei per classe
     * (quindi di tipo ExampleSetOmogeneo).*/
    public ArrayList raggruppaEsempi(ExampleSet eSet)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        int[] n = new int[this.dichiarazione.getNumClassi()];
        boolean[] esiste = new boolean[this.dichiarazione.getNumClassi()];
        for(int k=0;k<esiste.length;k++) esiste[k]=false; 
        for(int k=0;k<esiste.length;k++) n[k]=0;
        
        ArrayList ris = new ArrayList();
        for(int i=0;i<eSet.getSize();i++) 
        {
            Esempio es = eSet.getEsempio(i);
            String classeEs = es.getClasse();
            int j; 
            
            for(j=0;j<ris.size();j++)
            {
                ExampleSetOmogeneo insieme = (ExampleSetOmogeneo)ris.get(j);
                if (insieme.getClasse().equals(classeEs)){
                    insieme.addEsempio(es);
                    n[j]++;
                    break;
                }
                
            }
            if(!esiste[j]){
                    ExampleSetOmogeneo eso = new ExampleSetOmogeneo(classeEs);
                    eso.addEsempio(es);
                    ris.add(eso);
                    n[ris.lastIndexOf(eso)]++;
                    esiste[j]=true;
            }
        }
        //System.out.println("Fine raggruppamento: num. classi generate: "+ris.size()+".Num elementi: ["+n[0]+","+n[1]+"]");
        return ris;
    }
    
    
    
    /**Il metodo effettua il calcolo dell'entropia di un insieme di esempi.*/
    public double calcolaEntropia(ExampleSet eSet)
    throws FileNotFoundException, ParserConfigurationException, IOException, SAXException
    {
        ArrayList esempiRaggruppati = this.raggruppaEsempi(eSet);
        //Contiene per ogni classe la proporzione di esempi di quella classe sul totale
        //numero esempi della classe i/numero esempi totali. (La loro somma  1).
        double[] proporzioniEsempi = new double[esempiRaggruppati.size()];
        
        int nTot = eSet.getSize();
        for(int i=0;i<esempiRaggruppati.size();i++){
            ExampleSetOmogeneo eso = (ExampleSetOmogeneo)esempiRaggruppati.get(i);
            proporzioniEsempi[i] = eso.getSize()/(double)nTot;
        }
        
        double entropia=0;
        for(int i=0;i<esempiRaggruppati.size();i++){
            entropia += (-1)*proporzioniEsempi[i]*Math.log(proporzioniEsempi[i])/Math.log(2.0);
        }
        //System.out.println("###...L'entropia dell'insieme :  "+entropia);
        return entropia;
    }
    
    public void addNodoFoglia(FogliaAD n)
    {
        this.nodiFoglia.add(n);
    }
    
    public String valuta(Istanza i)
    throws AttributeNotFoundException
    {
        return this.nodoRadice.valuta(i);
    }
    
    
    public String toString()
    {
        String s="";
        for(int i=0;i<this.nodiFoglia.size();i++)
            s+=((FogliaAD)this.nodiFoglia.get(i)).toString()+"\n";
        return s;
    }
    
}
