/*
 * Decompiled with CFR 0.152.
 */
package Src.Servizi.NetworkSupport;

import Src.Servizi.Exception.AttributeNotFoundException;
import Src.Servizi.NetworkSupport.Message;
import Src.Servizi.NetworkSupport.NetworkNode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ServerThread
extends Thread
implements Serializable {
    protected int port;
    protected NetworkNode node;
    protected Socket connection;
    protected ObjectOutputStream out;
    protected ObjectInputStream in;

    public ServerThread(int n, NetworkNode networkNode, Socket socket) throws IOException {
        this.port = n;
        this.node = networkNode;
        this.connection = socket;
        this.out = new ObjectOutputStream(this.connection.getOutputStream());
        this.in = new ObjectInputStream(this.connection.getInputStream());
        this.start();
    }

    public void run() {
        try {
            this.waitForReceive();
        }
        catch (Exception exception) {
            System.out.println("ECCEZIONE Nodo " + this.node.getPort() + ":ServerThread.run():" + exception.getMessage());
        }
    }

    public void waitForReceive() throws IOException, InterruptedException, ClassNotFoundException {
        try {
            this.receiveMessage();
            this.waitForReceive();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Socket getConnection() {
        return this.connection;
    }

    public String receiveString() throws IOException, ClassNotFoundException {
        String string = (String)this.in.readObject();
        System.out.println("Server " + this.node.getPort() + ": \u00e8 arrivato il msg: " + string);
        return string;
    }

    public void sendString(String string) throws InterruptedException, IOException {
        ServerThread.sleep(100L);
        System.out.println("Server " + this.node.getPort() + ": Invio del msg:  " + string);
        this.out.writeObject(new String(string));
    }

    public Message receiveMessage() throws IOException, ClassNotFoundException, InterruptedException, ParserConfigurationException, SAXException, AttributeNotFoundException {
        Message message = (Message)this.in.readObject();
        return message;
    }

    public void sendMessage(Message message) throws InterruptedException, IOException {
        ServerThread.sleep(100L);
        System.out.println("Server " + this.node.getPort() + ": Invio del msg:  " + message + " verso " + this.connection.getPort());
        this.out.writeObject(message);
    }
}

