/*
 * Decompiled with CFR 0.152.
 */
package Src.Servizi.NetworkSupport;

import Src.Servizi.NetworkSupport.Message;
import Src.Servizi.NetworkSupport.NetworkNode;
import Src.Servizi.NetworkSupport.ServerThread;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;

public class ServerManager
extends Thread
implements Serializable {
    protected int port;
    protected NetworkNode node;
    protected ServerThread st;
    protected ServerSocket server;

    public ServerManager() {
    }

    public ServerManager(int n, NetworkNode networkNode) {
        this.port = n;
        this.node = networkNode;
        this.start();
    }

    public void run() {
        try {
            this.server = new ServerSocket(this.port);
            this.waitConnectionRequest();
        }
        catch (Exception exception) {
            System.out.println("ECCEZIONE Nodo " + this.node.getPort() + ":ServerManager.run():" + exception.getMessage());
        }
    }

    public void waitConnectionRequest() throws IOException, InterruptedException {
        while (true) {
            Socket socket = this.server.accept();
            this.st = new ServerThread(this.port, this.node, socket);
        }
    }

    public Socket getConnection() {
        return this.st.getConnection();
    }

    public ServerThread getServerThread() {
        return this.st;
    }

    public String receiveString() throws IOException, ClassNotFoundException {
        return this.st.receiveString();
    }

    public void sendString(String string) throws InterruptedException, IOException {
        this.st.sendString(string);
    }

    public Message receiveMessage() throws IOException, ClassNotFoundException {
        try {
            return this.st.receiveMessage();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    public void sendMessage(Message message) throws InterruptedException, IOException {
        this.st.sendMessage(message);
    }
}

