/*
 * Decompiled with CFR 0.152.
 */
package Src.Servizi.NetworkSupport;

import Src.Servizi.NetworkSupport.Address;
import Src.Servizi.NetworkSupport.ClientManager;
import Src.Servizi.NetworkSupport.Message;
import Src.Servizi.NetworkSupport.ServerManager;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NetworkNode
implements Serializable {
    protected InetAddress addr;
    protected int port;
    protected ClientManager cm;
    protected ServerManager sm;
    protected Address[] closeNodes = new Address[3];

    public NetworkNode() {
    }

    public NetworkNode(InetAddress inetAddress, int n) throws UnknownHostException, IOException {
        new NetworkNode(n);
        this.addr = inetAddress;
    }

    public NetworkNode(int n) throws UnknownHostException {
        this.addr = InetAddress.getLocalHost();
        this.port = n;
        this.closeNodes[0] = new Address(this.addr, this.port);
        this.closeNodes[1] = new Address(this.addr, this.port);
        this.closeNodes[2] = new Address(this.addr, this.port);
        this.sm = new ServerManager(n, this);
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setNextNode(Address address) {
        this.closeNodes[1] = address;
    }

    public void setLastNode(Address address) {
        this.closeNodes[0] = address;
    }

    public void setNextSecondNode(Address address) {
        this.closeNodes[2] = address;
    }

    public Address getNextNode() {
        return this.closeNodes[1];
    }

    public Address getLastNode() {
        return this.closeNodes[0];
    }

    public Address getNextSecondNode() {
        return this.closeNodes[2];
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public void connectToNextNode() throws IOException {
        if (this.cm == null) {
            this.cm = new ClientManager(this.getNextNode().getAddress(), this.getNextNode().getPort(), this);
        } else {
            this.cm.connectTo(this.getNextNode().getAddress(), this.getNextNode().getPort());
        }
    }

    public ClientManager getCm() {
        return this.cm;
    }

    public ServerManager getSm() {
        return this.sm;
    }

    public void resetSm() {
        this.sm = new ServerManager(this.getPort(), this);
    }

    public NetworkNode addInNet() throws IOException, InterruptedException {
        int n = this.port + 1;
        NetworkNode networkNode = new NetworkNode(n);
        System.out.println("Nodo " + this.getPort() + ":Entra un nuovo nodo in servizio sulla porta " + n);
        Address address = this.getNextNode();
        this.setNextNode(new Address(networkNode.getAddress(), networkNode.getPort()));
        this.setNextSecondNode(new Address(address.getAddress(), address.getPort()));
        networkNode.setNextNode(address);
        networkNode.setLastNode(new Address(this.getAddress(), this.getPort()));
        System.out.println("Nodo " + this.getPort() + ": Il mio nuovo successivo \u00e8 " + this.getNextNode().getPort());
        System.out.println("Nodo " + this.getPort() + ": Il mio nuovo precedente \u00e8 " + this.getLastNode().getPort());
        System.out.println("Nodo " + this.getPort() + ": Il mio secondo successivo \u00e8 " + this.getNextSecondNode().getPort());
        if (this.cm != null) {
            this.cm.closeConnection();
        }
        this.connectToNextNode();
        networkNode.connectToNextNode();
        networkNode.getCm().sendNewCloserMessage(networkNode.getLastNode(), networkNode.getNextNode(), networkNode.getNextSecondNode(), "add", true);
        return networkNode;
    }

    public boolean sendString(String string, String string2) throws InterruptedException, IOException {
        if (string2.equals("next")) {
            this.cm.sendString(string);
            return true;
        }
        if (string2.equals("last")) {
            this.sm.sendString(string);
            return true;
        }
        return false;
    }

    public String receiveString(String string) throws IOException, ClassNotFoundException {
        String string2;
        if (string.equals("next")) {
            string2 = this.cm.receiveString();
        } else if (string.equals("last")) {
            string2 = this.sm.receiveString();
        } else {
            String string3 = "Error";
            return "Error";
        }
        return string2;
    }

    public boolean sendMessage(Message message) throws InterruptedException, IOException {
        this.cm.sendMessage(message);
        return true;
    }

    public Message receiveMessage() throws IOException, ClassNotFoundException {
        return this.sm.receiveMessage();
    }

    public String toString() {
        String string = "";
        string = string + "Indirizzo nodo: " + this.getAddress() + ":" + this.getPort() + "\n";
        string = string + "Connessione al nodo precedente:" + this.getLastNode().getPort() + "\n";
        string = string + "Connessione al nodo successivo:" + this.getNextNode().getPort() + "\n";
        string = string + "Connessione al secondo nodo successivo:" + this.getNextSecondNode().getPort() + "\n";
        return string;
    }
}

