/*
 * Decompiled with CFR 0.152.
 */
package Src.Servizi.NetworkSupport;

import Src.Servizi.NetworkSupport.Address;
import Src.Servizi.NetworkSupport.Message;
import Src.Servizi.NetworkSupport.NetworkNode;
import Src.Servizi.NetworkSupport.NewCloserMessage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;

public class ClientManager
extends Thread
implements Serializable {
    protected InetAddress host;
    protected int port;
    protected Socket connection;
    protected NetworkNode node;
    protected ObjectInputStream in;
    protected ObjectOutputStream out;

    public ClientManager() {
    }

    public ClientManager(InetAddress inetAddress, int n, NetworkNode networkNode) throws IOException {
        this.node = networkNode;
        this.port = n;
        this.host = inetAddress;
        this.start();
    }

    public void run() {
        try {
            this.connectTo(this.host, this.port);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void connectTo(InetAddress inetAddress, int n) throws IOException {
        this.host = inetAddress;
        this.port = n;
        System.out.println("Nodo " + this.node.getPort() + ":Richiedo Connessione al nodo: " + this.port);
        try {
            this.connection = new Socket(inetAddress, n);
            this.out = new ObjectOutputStream(this.connection.getOutputStream());
            this.in = new ObjectInputStream(this.connection.getInputStream());
        }
        catch (Exception exception) {
            System.out.println("ECCEZIONE Nodo " + this.node.getPort() + ":ClientManage.connectTo():" + exception.getMessage());
        }
        System.out.println("Nodo " + this.node.getPort() + ":Connesso al nodo " + this.connection.getPort() + " effettuata con successo!");
    }

    public void closeConnection() throws IOException, InterruptedException {
        try {
            System.out.println("Nodo " + this.node.getPort() + " Richiesta disconnessione a" + this.getConnectionPort() + "...");
            this.connection.close();
            System.out.println("Nodo " + this.node.getPort() + ":Disconnessione al nodo " + this.connection.getPort() + " effettuata con successo!");
        }
        catch (Exception exception) {
            System.out.println("ECCEZIONE Nodo " + this.node.getPort() + ":ClientManage.closeConnetion():" + exception.getMessage());
        }
    }

    public int getConnectionPort() {
        return this.connection.getPort();
    }

    public Socket getConnection() {
        return this.connection;
    }

    public void sendString(String string) throws InterruptedException, IOException {
        ClientManager.sleep(100L);
        System.out.println("Client " + this.node.getPort() + ": Invio del msg:  " + string + " verso " + this.connection.getPort());
        this.out.writeObject(new String(string));
    }

    public String receiveString() throws IOException, ClassNotFoundException {
        String string = (String)this.in.readObject();
        System.out.println("Client " + this.node.getPort() + ": \u00e8 arrivato il msg: " + string);
        return string;
    }

    public void sendMessage(Message message) throws InterruptedException, IOException {
        ClientManager.sleep(100L);
        System.out.println("Client " + this.node.getPort() + ": Invio del msg:  " + message.getHeader().getIdMsg() + " verso " + this.connection.getPort());
        this.out.writeObject(message);
    }

    public void sendMessage(Message message, String string) throws InterruptedException, IOException {
        ClientManager.sleep(100L);
        System.out.println("Client " + this.node.getPort() + ": Inoltro il messaggio " + string + " verso " + this.connection.getPort());
        this.out.writeObject(message);
    }

    public Message receiveMessage() throws IOException, ClassNotFoundException {
        Message message = (Message)this.in.readObject();
        System.out.println("Client " + this.node.getPort() + ": \u00e8 arrivato il msg: " + message.getHeader().getIdMsg());
        return message;
    }

    public void sendNewCloserMessage(Address address, Address address2, Address address3, String string, boolean bl) throws InterruptedException, IOException {
        Address address4 = new Address(this.node.getAddress(), this.node.getPort());
        NewCloserMessage newCloserMessage = new NewCloserMessage(this.node.getAddress(), this.node.getPort(), "$$$$$$$$$$$$$$$$  " + this.node.getPort() + ":newCloser MESSAGE  $$$$$$$$$$$$$$$$", address, address2, address3, string, bl);
        this.sendMessage(newCloserMessage);
    }

    public void passNewCloserMessage(NewCloserMessage newCloserMessage) throws InterruptedException, IOException {
        this.sendMessage(newCloserMessage);
    }
}

