/*
 * Decompiled with CFR 0.152.
 */
package Src.LogicaDistribuito;

import Src.LogicaDistribuito.NodoClassificatore;
import Src.Servizi.NetworkSupport.FailRequest;
import Src.Servizi.NetworkSupport.InsertRequest;
import Src.Servizi.NetworkSupport.OffLineRequest;
import Src.Servizi.NetworkSupport.Queue;
import Src.Servizi.NetworkSupport.QueueManager;
import Src.Servizi.NetworkSupport.UpdateRequest;

public class QueueNetworkManager
extends QueueManager {
    NodoClassificatore node;

    public QueueNetworkManager(NodoClassificatore nodoClassificatore) {
        this.node = nodoClassificatore;
    }

    public void manageRequestOn(Queue queue) {
        try {
            if (queue == null) {
                Thread.sleep(1500L);
                this.node.manageEmptyQueues();
            } else if (queue.getName().equals("insertQueue")) {
                System.out.println("Gestore code di " + this.node.getPort() + ": Gestione delle coda di INSERT");
                InsertRequest insertRequest = (InsertRequest)queue.getFirstRequest();
                this.node.manageInsertRequest();
            } else if (queue.getName().equals("updateQueue")) {
                System.out.println("Gestore code di " + this.node.getPort() + ": Gestione delle coda di UPDATE");
                UpdateRequest updateRequest = (UpdateRequest)queue.getFirstRequest();
                this.node.manageUpdateRequest();
            } else if (queue.getName().equals("offlineQueue")) {
                System.out.println("Gestore code di " + this.node.getPort() + ": Gestione delle coda di OFFLINE");
                OffLineRequest offLineRequest = (OffLineRequest)queue.getFirstRequest();
                this.node.manageOffLineRequest(offLineRequest);
            } else if (queue.getName().equals("failQueue")) {
                System.out.println("Gestore code di " + this.node.getPort() + ": ORA MI PRENDO IL TOKEN E PIANTO TUTTA LA RETE!");
                FailRequest failRequest = (FailRequest)queue.getFirstRequest();
                this.node.manageFailRequest(failRequest);
            }
        }
        catch (Exception exception) {
            System.out.println("Gestore code di " + this.node.getPort() + ": Eccezione:" + exception.getMessage());
        }
    }

    public void manageRequests() {
        Queue queue = this.node.getQueue("insertQueue");
        Queue queue2 = this.node.getQueue("updateQueue");
        Queue queue3 = this.node.getQueue("offlineQueue");
        Queue queue4 = this.node.getQueue("failQueue");
        if (queue.getSize() == 0 && queue2.getSize() == 0 && queue3.getSize() == 0 && queue4.getSize() == 0) {
            System.out.println("Nodo " + this.node.getPort() + ":Non ci sono richieste da gestire.");
            this.manageRequestOn(null);
        }
        if (queue4.getSize() > 0) {
            this.manageRequestOn(queue4);
        }
        if (queue.getSize() > 0) {
            this.manageRequestOn(queue);
        }
        if (queue2.getSize() > 0) {
            this.manageRequestOn(queue2);
        }
        if (queue3.getSize() > 0) {
            this.manageRequestOn(queue3);
        }
    }
}

