/*
 * Decompiled with CFR 0.152.
 */
package Src.LogicaDistribuito;

import Src.Logica.Classificatore;
import Src.Logica.Esempio;
import Src.Logica.ExampleSet;
import Src.Logica.Istanza;
import Src.Logica.TrainingSet;
import Src.LogicaDistribuito.ClientManagerClassificatore;
import Src.LogicaDistribuito.CreationTokenManager;
import Src.LogicaDistribuito.QueueClassifyManager;
import Src.LogicaDistribuito.QueueNetworkManager;
import Src.LogicaDistribuito.ServerManagerClassificatore;
import Src.Servizi.Exception.AttributeNotFoundException;
import Src.Servizi.Exception.ElementNotFoundException;
import Src.Servizi.NetworkSupport.Address;
import Src.Servizi.NetworkSupport.AreYouLiveMessage;
import Src.Servizi.NetworkSupport.ClassifyRequest;
import Src.Servizi.NetworkSupport.ClientManager;
import Src.Servizi.NetworkSupport.CollectMessage;
import Src.Servizi.NetworkSupport.ElectionTokenMessage;
import Src.Servizi.NetworkSupport.FailRequest;
import Src.Servizi.NetworkSupport.ILiveMessage;
import Src.Servizi.NetworkSupport.InitializeMessage;
import Src.Servizi.NetworkSupport.InsertRequest;
import Src.Servizi.NetworkSupport.NetworkNode;
import Src.Servizi.NetworkSupport.NewCloserMessage;
import Src.Servizi.NetworkSupport.OffLineMessage;
import Src.Servizi.NetworkSupport.OffLineRequest;
import Src.Servizi.NetworkSupport.Queue;
import Src.Servizi.NetworkSupport.ServerManager;
import Src.Servizi.NetworkSupport.TokenMessage;
import Src.Servizi.NetworkSupport.UpdateMessage;
import Src.Servizi.NetworkSupport.UpdateRequest;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class NodoClassificatore
extends NetworkNode {
    protected Classificatore classificatore;
    protected TrainingSet tsLocale;
    protected TrainingSet tsGlobale;
    protected ExampleSet esempiNuovi;
    protected boolean token;
    protected Queue codaUpdate;
    protected Queue codaInsert;
    protected Queue codaClassify;
    protected Queue codaOffLine;
    protected Queue codaFail;
    protected QueueNetworkManager netRequestManager;
    protected QueueClassifyManager classifyManager;
    protected boolean updated;
    protected CreationTokenManager tokenManager;
    protected AreYouLiveMessage areYouLive;
    protected int tokenTimeout;

    public NodoClassificatore(int n) throws UnknownHostException, IOException {
        Address address;
        this.addr = InetAddress.getLocalHost();
        this.port = n;
        this.updated = false;
        this.closeNodes[0] = address = new Address(this.addr, this.port);
        this.closeNodes[1] = address;
        this.closeNodes[2] = address;
        this.codaOffLine = new Queue("offlineQueue", 3);
        this.codaInsert = new Queue("insertQueue", 2);
        this.codaUpdate = new Queue("updateQueue", 1);
        this.codaClassify = new Queue("classifyQueue", 1);
        this.codaFail = new Queue("failQueue", 4);
        this.sm = new ServerManagerClassificatore(n, this);
        this.netRequestManager = new QueueNetworkManager(this);
        this.classifyManager = new QueueClassifyManager(this);
        try {
            this.tsLocale = new TrainingSet();
            this.tsGlobale = new TrainingSet();
            this.esempiNuovi = new ExampleSet();
            this.setToken(false);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public NodoClassificatore(int n, int n2) throws UnknownHostException, IOException {
        new NodoClassificatore(n);
        this.tokenTimeout = n2;
        this.tokenManager = new CreationTokenManager(this.tokenTimeout, this);
    }

    public Classificatore getClassificatore() {
        return this.classificatore;
    }

    public CreationTokenManager getCreationTokenManager() {
        return this.tokenManager;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean hasToken() {
        return this.token;
    }

    public void setUpdated(boolean bl) throws InterruptedException {
        if (bl) {
            System.out.println("Nodo " + this.getPort() + ":Riattivazione del gestore di richieste di classificazione.");
            this.updated = true;
            this.classifyManager.resumeManager();
        } else {
            System.out.println("Nodo " + this.getPort() + ":Sospensione del gestore di richieste di classificazione.");
            this.updated = false;
            this.classifyManager.suspendManager();
        }
    }

    public void setToken(boolean bl) throws InterruptedException {
        if (bl) {
            System.out.println("Nodo " + this.getPort() + ":Riattivazione del gestore di richieste di rete.");
            this.token = true;
            this.netRequestManager.resumeManager();
        } else {
            System.out.println("Nodo " + this.getPort() + ":Sospensione del gestore di richieste di rete.");
            this.token = false;
            this.netRequestManager.suspendManager();
        }
    }

    public Queue getQueue(String string) {
        if (this.codaInsert.getName().equals(string)) {
            return this.codaInsert;
        }
        if (this.codaUpdate.getName().equals(string)) {
            return this.codaUpdate;
        }
        if (this.codaOffLine.getName().equals(string)) {
            return this.codaOffLine;
        }
        if (this.codaClassify.getName().equals(string)) {
            return this.codaClassify;
        }
        if (this.codaFail.getName().equals(string)) {
            return this.codaFail;
        }
        return null;
    }

    public NetworkNode addInNet() throws IOException, InterruptedException {
        int n = this.port + 1;
        NodoClassificatore nodoClassificatore = new NodoClassificatore(n);
        System.out.println("Nodo " + this.getPort() + ":Entra un nuovo nodo in servizio sulla porta " + n);
        Address address = this.getNextNode();
        this.setNextNode(new Address(nodoClassificatore.getAddress(), nodoClassificatore.getPort()));
        this.setNextSecondNode(address);
        nodoClassificatore.setNextNode(address);
        nodoClassificatore.setLastNode(new Address(this.getAddress(), this.getPort()));
        System.out.println("Nodo " + this.getPort() + ": Il mio nuovo successivo \u00e8 " + this.getNextNode().getPort());
        System.out.println("Nodo " + this.getPort() + ": Il mio nuovo precedente \u00e8 " + this.getLastNode().getPort());
        System.out.println("Nodo " + this.getPort() + ": Il mio secondo successivo \u00e8 " + this.getNextSecondNode().getPort());
        if (this.cm != null) {
            this.cm.closeConnection();
        }
        this.connectToNextNode();
        nodoClassificatore.connectToNextNode();
        nodoClassificatore.cm.sendNewCloserMessage(nodoClassificatore.getLastNode(), nodoClassificatore.getNextNode(), nodoClassificatore.getNextSecondNode(), "add", true);
        return nodoClassificatore;
    }

    public void creaClassificatore(TrainingSet trainingSet) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, ElementNotFoundException, AttributeNotFoundException {
        this.classificatore = new Classificatore(trainingSet);
    }

    public ExampleSet getNuoviEsempi() throws FileNotFoundException, ParserConfigurationException, IOException, SAXException {
        ExampleSet exampleSet = this.esempiNuovi;
        this.esempiNuovi = new ExampleSet();
        return exampleSet;
    }

    public boolean isCovered(Esempio esempio) throws AttributeNotFoundException {
        return this.classificatore.isCovered(esempio);
    }

    public void addNewExample(Esempio esempio) {
        this.esempiNuovi.addEsempio(esempio);
    }

    public ExampleSet addNewExamples(ExampleSet exampleSet) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException {
        ExampleSet exampleSet2 = new ExampleSet();
        int n = 0;
        while (n < this.esempiNuovi.getSize()) {
            this.tsLocale.addEsempio(this.esempiNuovi.getEsempio(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < exampleSet.getSize()) {
            exampleSet2.addEsempio(exampleSet.getEsempio(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.esempiNuovi.getSize()) {
            exampleSet2.addEsempio(this.esempiNuovi.getEsempio(n3));
            ++n3;
        }
        return exampleSet2;
    }

    public void updateTree(ExampleSet exampleSet) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException, InterruptedException {
        this.emptyUpdateQueue();
        this.esempiNuovi = new ExampleSet();
        System.out.println("Nodo " + this.getPort() + ": Aggiornamento dell'Albero...");
        int n = 0;
        while (n < exampleSet.getSize()) {
            this.tsGlobale.addEsempio(exampleSet.getEsempio(n));
            ++n;
        }
        this.classificatore = new Classificatore(this.tsGlobale);
        System.out.println("Nodo " + this.getPort() + ": Aggiornameto dell'albero effettuato con successo!");
        this.setUpdated(true);
    }

    public void connectToNextNode() throws IOException {
        if (this.cm == null) {
            this.cm = new ClientManagerClassificatore(this.getNextNode().getAddress(), this.getNextNode().getPort(), this);
        } else {
            this.cm.connectTo(this.getNextNode().getAddress(), this.getNextNode().getPort());
        }
    }

    public void manageCollectMessage(CollectMessage collectMessage) throws InterruptedException, IOException, ParserConfigurationException, SAXException, AttributeNotFoundException {
        if (collectMessage.getHeader().getfromPort() == this.getPort() && collectMessage.getHeader().getfromAddr().equals(this.getAddress())) {
            ((ClientManagerClassificatore)this.cm).getTimeout().ferma();
            System.out.println("Server " + this.getPort() + ":Ho ricevuto un msg Collect Message creato da me");
            ExampleSet exampleSet = collectMessage.getContent();
            System.out.println("Server " + this.getPort() + ":ExampleSet raccolto: ");
            System.out.println(exampleSet);
            ((ClientManagerClassificatore)this.cm).sendUpdateMessage(exampleSet);
            this.updateTree(exampleSet);
        } else {
            this.setUpdated(false);
            System.out.println("Server " + this.getPort() + ":Ho ricevuto un msg Collect Message creato da " + collectMessage.getHeader().getfromPort());
            ExampleSet exampleSet = collectMessage.getContent();
            System.out.println("Server " + this.getPort() + ":ExampleSet raccolto fin'ora: ");
            System.out.println(exampleSet);
            if (this.esempiNuovi.getSize() > 0) {
                exampleSet = this.addNewExamples(exampleSet);
            }
            System.out.println("Server " + this.getPort() + ":ExampleSet che sto per inviare: ");
            System.out.println(exampleSet);
            ((ClientManagerClassificatore)this.cm).passCollectMessage(collectMessage, exampleSet);
        }
    }

    public void manageUpdateMessage(UpdateMessage updateMessage) throws InterruptedException, IOException, ParserConfigurationException, SAXException, AttributeNotFoundException, ClassNotFoundException {
        if (updateMessage.getHeader().getfromPort() == this.getPort() && updateMessage.getHeader().getfromAddr().equals(this.getAddress())) {
            ((ClientManagerClassificatore)this.cm).getTimeout().ferma();
            System.out.println("Server " + this.getPort() + ":Ho ricevuto un msg UpdateMessage creato da me");
            ((ClientManagerClassificatore)this.cm).sendTokenMessage();
        } else {
            System.out.println("Server " + this.getPort() + ":Ho ricevuto un msg UpdateMessage creato da " + updateMessage.getHeader().getfromPort());
            ExampleSet exampleSet = updateMessage.getContent();
            ((ClientManagerClassificatore)this.cm).passUpdateMessage(updateMessage);
            this.updateTree(exampleSet);
        }
    }

    public void manageTokenMessage(TokenMessage tokenMessage) {
        try {
            if (this.tokenManager != null) {
                System.out.println("Nodo " + this.getPort() + ":Reset del token timeout");
                this.tokenManager.resetTimeout();
                System.out.println("Nodo " + this.getPort() + ":Il mio nuovo token timeout \u00e8 " + this.tokenManager.getTokenTimeout());
                if (this.tokenManager.getETSended()) {
                    this.tokenManager.setInvalided();
                }
            }
            this.setToken(true);
        }
        catch (Exception exception) {
            System.out.println("Server " + this.getPort() + ":ECCEZIONE manageTokenMessage()" + exception.getMessage());
        }
    }

    public void manageInitializeMessage(InitializeMessage initializeMessage) {
        try {
            TrainingSet trainingSet = initializeMessage.getContent();
            System.out.println("Server " + this.getPort() + ":Creazione dell'Albero decisionale...");
            this.creaClassificatore(trainingSet);
            System.out.println("Server " + this.getPort() + ":Creazione avvenuta con successo!...");
        }
        catch (Exception exception) {
            System.out.println("Server " + this.getPort() + ":ECCEZIONE manageInitializeMessage()" + exception.getMessage());
        }
    }

    public void manageILiveMessage(ILiveMessage iLiveMessage) {
        try {
            if (!iLiveMessage.isRecoveryMsg()) {
                this.setToken(false);
            }
        }
        catch (Exception exception) {
            System.out.println("Nodo " + this.getPort() + ":ECCEZIONE manageILiverMessage()" + exception.getMessage());
        }
    }

    public void receivedIsertRequest(InsertRequest insertRequest) throws AttributeNotFoundException {
        this.codaInsert.putInQueue(insertRequest);
    }

    public void receivedUpdateRequest(UpdateRequest updateRequest) throws AttributeNotFoundException {
        System.out.println("Nodo " + this.getPort() + ": Ho effettuato questa NUOVA OSSERVAZIONE: " + updateRequest.getContent());
        Esempio esempio = updateRequest.getContent();
        this.addNewExample(esempio);
        if (this.classificatore == null || !this.isCovered(esempio)) {
            System.out.println("Nodo " + this.getPort() + ": NON \u00e8 gi\u00e0 coperta dall'albero attuale --> La metto in coda.");
            this.codaUpdate.putInQueue(updateRequest);
        } else {
            System.out.println("Nodo " + this.getPort() + ": E' gi\u00e0 coperta dall'albero attuale --> Metto solo l'osservarzione nella lista dei nuovi esempi.");
        }
    }

    public void receivedClassifyRequest(ClassifyRequest classifyRequest) throws AttributeNotFoundException {
        if (this.codaClassify.getSize() == 0 && this.isUpdated()) {
            this.manageClassifyRequest(classifyRequest);
        }
        this.codaClassify.putInQueue(classifyRequest);
    }

    public void receivedOffLineRequest(OffLineRequest offLineRequest) throws AttributeNotFoundException {
        this.codaOffLine.putInQueue(offLineRequest);
    }

    public void emptyUpdateQueue() {
        this.codaUpdate.reset();
    }

    public void manageUpdateRequest() throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException, InterruptedException {
        this.setUpdated(false);
        ExampleSet exampleSet = new ExampleSet();
        int n = 0;
        while (n < this.esempiNuovi.getSize()) {
            exampleSet.addEsempio(this.esempiNuovi.getEsempio(n));
            ++n;
        }
        ((ClientManagerClassificatore)this.cm).sendCollectMessage(exampleSet);
        this.emptyUpdateQueue();
    }

    public void manageInsertRequest() throws IOException, InterruptedException, ClassNotFoundException {
        this.addInNet();
        if (this.tsGlobale.getSize() > 0) {
            ((ClientManagerClassificatore)this.cm).sendInitializeMessage(this.tsGlobale);
        }
        ((ClientManagerClassificatore)this.cm).sendTokenMessage();
    }

    public void manageOffLineRequest(OffLineRequest offLineRequest) throws IOException, InterruptedException, ClassNotFoundException {
        Address address = new Address(this.getAddress(), this.getPort());
        ((ClientManagerClassificatore)this.cm).sendOffLineMessage(address, true);
        this.cm.closeConnection();
    }

    public void manageEmptyQueues() throws IOException, InterruptedException, ClassNotFoundException {
        ((ClientManagerClassificatore)this.cm).sendTokenMessage();
    }

    public String manageClassifyRequest(ClassifyRequest classifyRequest) throws AttributeNotFoundException {
        Istanza istanza = classifyRequest.getContent();
        String string = this.classificatore.classifica(istanza);
        System.out.println("L'istanza \u00e8 stata classificata " + string);
        return string;
    }

    public void manageNodeFail() {
        try {
            System.out.println("Nodo " + this.getPort() + ":Gestione della caduta del mio nodo successivo.");
            Address address = this.getNextNode();
            this.cm.closeConnection();
            this.setNextNode(this.getNextSecondNode());
            this.connectToNextNode();
            ((ClientManagerClassificatore)this.cm).sendOffLineMessage(address, true);
        }
        catch (Exception exception) {
            System.out.println("Nodo " + this.getPort() + ":Eccezione su manageFailNode():" + exception.getMessage());
        }
    }

    public void manageNewCloserMessage(NewCloserMessage newCloserMessage) {
        try {
            Address[] addressArray = newCloserMessage.getContent();
            Address address = new Address(newCloserMessage.getHeader().getfromAddr(), newCloserMessage.getHeader().getfromPort());
            if (newCloserMessage.getEvent().equals("add")) {
                if (newCloserMessage.getHeader().getfromPort() == this.getPort() && newCloserMessage.getHeader().getfromAddr().equals(this.getAddress())) {
                    this.setNextSecondNode(addressArray[2]);
                } else if (this.getNextNode().getPort() == addressArray[0].getPort()) {
                    this.setNextSecondNode(new Address(newCloserMessage.getHeader().getfromAddr(), newCloserMessage.getHeader().getfromPort()));
                    System.out.println("Nodo " + this.getPort() + ": Il mio secondo successivo sar\u00e0 " + this.getNextSecondNode().getPort());
                    ((ClientManagerClassificatore)this.cm).passNewCloserMessage(newCloserMessage);
                } else if (addressArray[1].getPort() == this.getPort()) {
                    this.setLastNode(new Address(newCloserMessage.getHeader().getfromAddr(), newCloserMessage.getHeader().getfromPort()));
                    newCloserMessage.setNewSecondNext(this.getNextNode());
                    ((ClientManagerClassificatore)this.cm).passNewCloserMessage(newCloserMessage);
                } else if (addressArray[0].getPort() == this.getPort()) {
                    this.setNextNode(address);
                    this.setNextSecondNode(addressArray[1]);
                    ((ClientManagerClassificatore)this.cm).passNewCloserMessage(newCloserMessage);
                } else {
                    ((ClientManagerClassificatore)this.cm).passNewCloserMessage(newCloserMessage);
                }
            } else if (newCloserMessage.getEvent().equals("offline")) {
                if (newCloserMessage.getHeader().getfromPort() == this.getPort() && newCloserMessage.getHeader().getfromAddr().equals(this.getAddress())) {
                    this.setLastNode(addressArray[0]);
                    if (newCloserMessage.withToken()) {
                        this.setToken(true);
                    } else {
                        ((ClientManagerClassificatore)this.cm).passAreYouLiveMessage(this.areYouLive);
                    }
                } else if (this.getNextSecondNode().getPort() == addressArray[0].getPort()) {
                    this.setNextSecondNode(new Address(newCloserMessage.getHeader().getfromAddr(), newCloserMessage.getHeader().getfromPort()));
                    ((ClientManagerClassificatore)this.cm).passNewCloserMessage(newCloserMessage);
                } else if (this.getNextNode().getPort() == addressArray[0].getPort()) {
                    this.cm.closeConnection();
                    System.out.println("Nodo " + this.getPort() + ": Il mio successivo sar\u00e0 " + address.getPort());
                    this.setNextNode(address);
                    this.connectToNextNode();
                    newCloserMessage.setNewLastNode(new Address(this.addr, this.port));
                    this.setNextSecondNode(addressArray[1]);
                    ((ClientManagerClassificatore)this.cm).passNewCloserMessage(newCloserMessage);
                } else {
                    ((ClientManagerClassificatore)this.cm).passNewCloserMessage(newCloserMessage);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Nodo " + this.getPort() + ":ECCEZIONE manageNewCloserMessage()" + exception.getMessage());
        }
    }

    public void manageOffLineMessage(OffLineMessage offLineMessage) throws InterruptedException, IOException {
        Address address = offLineMessage.getContent();
        this.cm.sendNewCloserMessage(address, this.getNextNode(), this.getNextSecondNode(), "offline", true);
    }

    public void findWhoFailed(String string) throws InterruptedException, IOException, ClassNotFoundException {
        ((ClientManagerClassificatore)this.cm).sendAreYouLiveMessage(null);
    }

    public void manageAreYouLiveMessage(AreYouLiveMessage areYouLiveMessage) {
        try {
            if (areYouLiveMessage.getNodeFailAddress() != null) {
                Address address = areYouLiveMessage.getNodeFailAddress();
                System.out.println("Nodo " + this.getPort() + ":Sono stato incaricato di gestire la procedura di Recovery.");
                areYouLiveMessage.setNodeFailAddress(null);
                this.areYouLive = areYouLiveMessage;
                this.cm.sendNewCloserMessage(address, this.getNextNode(), this.getNextSecondNode(), "offline", false);
            } else if (areYouLiveMessage.getHeader().getfromPort() == this.getPort() && areYouLiveMessage.getHeader().getfromAddr().equals(this.getAddress())) {
                if (areYouLiveMessage.getHeader().getTipo().equals("AreYouLive")) {
                    this.netRequestManager.manageRequests();
                } else if (areYouLiveMessage.getHeader().getTipo().equals("electionToken")) {
                    this.tokenManager.manageElectionTokenMessage((ElectionTokenMessage)areYouLiveMessage);
                }
            } else if (areYouLiveMessage.getHeader().getTipo().equals("AreYouLive")) {
                ((ClientManagerClassificatore)this.cm).passAreYouLiveMessage(areYouLiveMessage);
            } else if (areYouLiveMessage.getHeader().getTipo().equals("electionToken")) {
                this.tokenManager.manageElectionTokenMessage((ElectionTokenMessage)areYouLiveMessage);
            }
        }
        catch (Exception exception) {
            System.out.println("Server " + this.getPort() + ":ECCEZIONE manageAreYouLiveMessage()" + exception.getMessage());
        }
    }

    public void manageRecoveryRing(AreYouLiveMessage areYouLiveMessage) {
        try {
            System.out.println("Nodo " + this.getPort() + ":Innesco la procedura di Recovery.");
            Address address = this.getNextNode();
            this.cm.closeConnection();
            this.setNextNode(this.getNextSecondNode());
            this.connectToNextNode();
            if (areYouLiveMessage.getHeader().getTipo().equals("AreYouLive")) {
                areYouLiveMessage.setNodeFailAddress(address);
                ((ClientManagerClassificatore)this.cm).passAreYouLiveMessage(areYouLiveMessage);
            } else {
                ((ElectionTokenMessage)areYouLiveMessage).setNodeFailAddress(address);
                ((ClientManagerClassificatore)this.cm).passElectionTokenMessage((ElectionTokenMessage)areYouLiveMessage);
            }
        }
        catch (Exception exception) {
            System.out.println("Nodo " + this.getPort() + ":Eccezione su manageRecoveryRing():" + exception.getMessage());
        }
    }

    public void setTokenTimeout(int n) {
        this.tokenTimeout = n;
        this.tokenManager = new CreationTokenManager(this.tokenTimeout, this);
    }

    public int getTokenTimeout() {
        return this.tokenManager.getTokenTimeout();
    }

    public void manageFailRequest(FailRequest failRequest) throws IOException, InterruptedException, ClassNotFoundException {
        if (this.tokenManager != null) {
            this.tokenManager.stopTimeout();
        }
        ClientManager.sleep(99999999L);
        ServerManager.sleep(99999999L);
    }

    public void receivedFailRequest(FailRequest failRequest) throws AttributeNotFoundException {
        this.codaFail.putInQueue(failRequest);
    }

    public void simulaFailSenzaToken() throws IOException, InterruptedException, ClassNotFoundException {
        System.out.println("Nodo " + this.getPort() + ": CAAAAAAAAAADOOOOOOOOOOOOOOO");
        this.cm.suspend();
        this.sm.getServerThread().suspend();
        this.sm.suspend();
    }
}

