/*
 * Decompiled with CFR 0.152.
 */
package Src.LogicaDistribuito;

import Src.LogicaDistribuito.ClientManagerClassificatore;
import Src.LogicaDistribuito.NodoClassificatore;
import Src.LogicaDistribuito.TokenTimeout;
import Src.Servizi.NetworkSupport.ElectionTokenMessage;
import Src.Servizi.NetworkSupport.TokenMessage;
import java.io.IOException;

public class CreationTokenManager {
    protected int t;
    protected int MINPRIORITY = 10000;
    protected NodoClassificatore node;
    protected boolean invalided;
    protected boolean ETSended;
    protected int priority;
    protected int mostPriority;
    protected TokenTimeout tt;

    public CreationTokenManager(int n, NodoClassificatore nodoClassificatore) {
        this.t = n;
        this.node = nodoClassificatore;
        this.priority = nodoClassificatore.getPort();
        this.invalided = false;
        this.ETSended = false;
        this.mostPriority = this.MINPRIORITY;
        this.tt = new TokenTimeout(this.t, this.node, this);
    }

    public void setInvalided() {
        this.invalided = true;
    }

    public boolean getETSended() {
        return this.ETSended;
    }

    public int getPriorit\u00e0() {
        return this.priority;
    }

    public void resetMostPriority() {
        this.mostPriority = 10000;
    }

    public void setTimeout(int n) {
        this.t = n;
        this.tt.ferma();
        this.tt = new TokenTimeout(this.t, this.node, this);
    }

    public int getTokenTimeout() {
        return this.t;
    }

    public boolean isMorePriority(int n) {
        return n < this.mostPriority;
    }

    public void resetTimeout() {
        this.tt.ferma();
        this.mostPriority = this.MINPRIORITY;
        this.tt = new TokenTimeout(this.t, this.node, this);
    }

    public void stopTimeout() {
        this.tt.ferma();
    }

    public void resetManager() {
        this.invalided = false;
        this.ETSended = false;
        this.resetTimeout();
    }

    public void manageTimeout() throws InterruptedException, IOException, ClassNotFoundException {
        System.out.println("Nodo " + this.node.getPort() + ": Il TokenTimeout \u00e8 scaduto... Inizio il protocollo di elezione:");
        if (this.isMorePriority(this.priority)) {
            System.out.println("Nodo " + this.node.getPort() + ": Creato un ET di priorit\u00e0: " + this.priority);
            ((ClientManagerClassificatore)this.node.getCm()).sendElectionTokenMessage();
            this.ETSended = true;
            this.mostPriority = this.priority;
        } else {
            System.out.println("Nodo " + this.node.getPort() + ": Il nodo " + this.mostPriority + " \u00e8 pi\u00f9 prioritario di me e ha gia creato un Token di elezione. --> ATTENDO pazientemente il token.");
            this.mostPriority = this.MINPRIORITY;
            this.tt = new TokenTimeout(this.t, this.node, this);
        }
    }

    public void manageElectionTokenMessage(ElectionTokenMessage electionTokenMessage) throws InterruptedException, IOException, ClassNotFoundException {
        if (electionTokenMessage.getHeader().getfromPort() == this.node.getPort() && electionTokenMessage.getHeader().getfromAddr().equals(this.node.getAddress())) {
            System.out.println("Nodo " + this.node.getPort() + ": Ho ricevuto l'ET inviato da me.");
            if (this.invalided) {
                System.out.println("Nodo " + this.node.getPort() + ": Mentre il mio ET era in giro ho ricevuto il token.");
            } else if (this.mostPriority == this.priority) {
                System.out.println("Nodo " + this.node.getPort() + ": Genero il Token.");
                this.node.manageTokenMessage(new TokenMessage(this.node.getAddress(), this.node.getPort(), "token"));
            } else {
                System.out.println("Nodo " + this.node.getPort() + ": Mentre il mio ET era in giro ho ricevuto ET pi\u00f9 prioritari.");
            }
        } else {
            if (this.node.hasToken()) {
                System.out.println("Nodo " + this.node.getPort() + ": Ho ricevuto l'ET inviato da " + electionTokenMessage.getPriority());
                System.out.println("Nodo " + this.node.getPort() + ": IO HO IL TOKEN! --> Scarto l'ET inviatomi.");
                return;
            }
            if (this.isMorePriority(electionTokenMessage.getPriority())) {
                System.out.println("Nodo " + this.node.getPort() + ": Ho ricevuto l'ET inviato da " + electionTokenMessage.getPriority());
                this.mostPriority = electionTokenMessage.getPriority();
                System.out.println("Nodo " + this.node.getPort() + ": \u00e8 IL PIU PRIORITARIO ricevuto fin'ora. ");
                ((ClientManagerClassificatore)this.node.getCm()).passElectionTokenMessage(electionTokenMessage);
                return;
            }
            System.out.println("Nodo " + this.node.getPort() + ": Ho ricevuto l'ET inviato da " + electionTokenMessage.getPriority());
            System.out.println("Nodo " + this.node.getPort() + ": Il nodo " + this.mostPriority + " ha generato un ET pi\u00f9 prioritario --> LO SCARTO!.");
            return;
        }
        this.ETSended = false;
        this.invalided = false;
        this.mostPriority = this.MINPRIORITY;
    }
}

