/*
 * Decompiled with CFR 0.152.
 */
package Src.LogicaDistribuito;

import Src.Logica.ExampleSet;
import Src.Logica.TrainingSet;
import Src.LogicaDistribuito.NodoClassificatore;
import Src.Servizi.NetworkSupport.Address;
import Src.Servizi.NetworkSupport.AreYouLiveMessage;
import Src.Servizi.NetworkSupport.ClientManager;
import Src.Servizi.NetworkSupport.CollectMessage;
import Src.Servizi.NetworkSupport.ElectionTokenMessage;
import Src.Servizi.NetworkSupport.ILiveMessage;
import Src.Servizi.NetworkSupport.InitializeMessage;
import Src.Servizi.NetworkSupport.NetworkNode;
import Src.Servizi.NetworkSupport.OffLineMessage;
import Src.Servizi.NetworkSupport.Timeout;
import Src.Servizi.NetworkSupport.TokenMessage;
import Src.Servizi.NetworkSupport.UpdateMessage;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;

public class ClientManagerClassificatore
extends ClientManager {
    protected Timeout timeout;

    public ClientManagerClassificatore() {
    }

    public ClientManagerClassificatore(InetAddress inetAddress, int n, NetworkNode networkNode) throws IOException {
        super(inetAddress, n, (NodoClassificatore)networkNode);
    }

    public Timeout getTimeout() {
        return this.timeout;
    }

    public void sendCollectMessage(ExampleSet exampleSet) throws InterruptedException, IOException {
        try {
            int n = 80000;
            CollectMessage collectMessage = new CollectMessage(this.node.getAddress(), this.node.getPort(), "cccccccccccc " + this.node.getPort() + ":COLLECT MESSAGE cccccccccccc", exampleSet);
            this.sendMessage(collectMessage);
            this.timeout = new Timeout(n, (NodoClassificatore)this.node, "collect");
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void sendUpdateMessage(ExampleSet exampleSet) throws InterruptedException, IOException {
        int n = 150000;
        UpdateMessage updateMessage = new UpdateMessage(this.node.getAddress(), this.node.getPort(), "uuuuuuuuuuuu " + this.node.getPort() + ":UPDATE MESSAGE uuuuuuuuuuuu", exampleSet);
        this.sendMessage(updateMessage);
        this.timeout = new Timeout(n, (NodoClassificatore)this.node, "update");
    }

    public void sendInitializeMessage(TrainingSet trainingSet) throws InterruptedException, IOException {
        InitializeMessage initializeMessage = new InitializeMessage(this.node.getAddress(), this.node.getPort(), "iiiiiiiiiiiiiiiiiiii  " + this.node.getPort() + ":INITIALIZE MESSAGE  iiiiiiiiiiiiiiiiiiii", trainingSet);
        this.sendMessage(initializeMessage);
    }

    public void sendTokenMessage() throws InterruptedException, IOException, ClassNotFoundException {
        int n = this.connection.getSoTimeout();
        try {
            this.connection.setSoTimeout(8000);
            TokenMessage tokenMessage = new TokenMessage(this.node.getAddress(), this.node.getPort(), "*********************  " + this.node.getPort() + ":INVIO DEL TOKEN  *********************");
            this.sendMessage(tokenMessage);
            this.receiveILiveMessage();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            System.out.println("Nodo " + this.node.getPort() + ": RILEVATA la caduta del nodo successivo.");
            ((NodoClassificatore)this.node).manageNodeFail();
        }
        this.connection.setSoTimeout(n);
    }

    public void receiveILiveMessage() throws InterruptedException, IOException, ClassNotFoundException {
        ILiveMessage iLiveMessage = (ILiveMessage)this.receiveMessage();
        ((NodoClassificatore)this.node).manageILiveMessage(iLiveMessage);
    }

    public void passCollectMessage(CollectMessage collectMessage, ExampleSet exampleSet) throws InterruptedException, IOException {
        CollectMessage collectMessage2 = new CollectMessage(collectMessage.getHeader(), exampleSet);
        this.sendMessage(collectMessage2);
    }

    public void passUpdateMessage(UpdateMessage updateMessage) throws InterruptedException, IOException {
        this.sendMessage(updateMessage);
    }

    public void sendOffLineMessage(Address address, boolean bl) throws InterruptedException, IOException {
        OffLineMessage offLineMessage = new OffLineMessage(this.node.getAddress(), this.node.getPort(), "---------------------  " + this.node.getPort() + ":offline MESSAGE  ---------------------", address, bl);
        this.sendMessage(offLineMessage);
    }

    public void sendAreYouLiveMessage(Address address) throws InterruptedException, IOException, ClassNotFoundException {
        AreYouLiveMessage areYouLiveMessage = null;
        int n = this.connection.getSoTimeout();
        try {
            this.connection.setSoTimeout(8000);
            areYouLiveMessage = new AreYouLiveMessage(this.node.getAddress(), this.node.getPort(), "???????????????????? " + this.node.getPort() + ":AreYouLive MESSAGE ????????????????????", address);
            this.sendMessage(areYouLiveMessage);
            this.receiveILiveMessage();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            System.out.println("Nodo " + this.node.getPort() + ": RILEVATA la caduta del mio nodo successivo.");
            ((NodoClassificatore)this.node).manageRecoveryRing(areYouLiveMessage);
        }
        this.connection.setSoTimeout(n);
    }

    public void passAreYouLiveMessage(AreYouLiveMessage areYouLiveMessage) throws InterruptedException, IOException, ClassNotFoundException {
        int n = this.connection.getSoTimeout();
        try {
            this.connection.setSoTimeout(8000);
            this.sendMessage(areYouLiveMessage, "???????????????????? " + areYouLiveMessage.getHeader().getfromPort() + ":AreYouLive MESSAGE ????????????????????");
            this.receiveILiveMessage();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            System.out.println("Nodo " + this.node.getPort() + ": RILEVATA la caduta del mio nodo successivo con la procedura AreYouLive.");
            ((NodoClassificatore)this.node).manageRecoveryRing(areYouLiveMessage);
        }
        this.connection.setSoTimeout(n);
    }

    public void sendElectionTokenMessage() throws InterruptedException, IOException, ClassNotFoundException {
        int n = this.connection.getSoTimeout();
        ElectionTokenMessage electionTokenMessage = new ElectionTokenMessage(this.node.getAddress(), this.node.getPort(), "-----------  " + this.node.getPort() + ":ELECTION TOKEN  -----------", null);
        try {
            this.connection.setSoTimeout(8000);
            this.sendMessage(electionTokenMessage);
            this.receiveILiveMessage();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            System.out.println("Nodo " + this.node.getPort() + ": RILEVATA la caduta del nodo successivo nel passaggio dell'ELECTION TOKEN.");
            ((NodoClassificatore)this.node).manageRecoveryRing(electionTokenMessage);
        }
        this.connection.setSoTimeout(n);
    }

    public void passElectionTokenMessage(ElectionTokenMessage electionTokenMessage) throws InterruptedException, IOException, ClassNotFoundException {
        int n = this.connection.getSoTimeout();
        try {
            this.connection.setSoTimeout(8000);
            this.sendMessage(electionTokenMessage, "-----------  " + electionTokenMessage.getHeader().getfromPort() + ":ELECTION TOKEN  -----------");
            this.receiveILiveMessage();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            System.out.println("Nodo " + this.node.getPort() + ": RILEVATA la caduta del nodo successivo nel passaggio dell'ELECTION TOKEN.");
            ((NodoClassificatore)this.node).manageRecoveryRing(electionTokenMessage);
        }
        this.connection.setSoTimeout(n);
    }
}

