/*
 * Decompiled with CFR 0.152.
 */
package Src.Logica;

import Src.Logica.AlberoDecisionale;
import Src.Logica.AttributoContinuo;
import Src.Logica.AttributoDiscreto;
import Src.Logica.Dichiarazione;
import Src.Logica.ExampleSet;
import Src.Logica.ExampleSetOmogeneo;
import Src.Logica.FogliaAD;
import Src.Logica.Istanza;
import Src.Logica.Nodo;
import Src.Servizi.Exception.AttributeNotFoundException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class NodoAD
implements Nodo {
    private String nome;
    private NodoAD nodoPadre;
    private ArrayList nodiFigli;
    private ExampleSet esempi;
    private Dichiarazione dichiarazione;
    private String nomeAttributo;
    private AlberoDecisionale albero;
    private ArrayList attributiDisponibili;
    private int altezzaNodo;

    public NodoAD(NodoAD nodoAD, ExampleSet exampleSet, Dichiarazione dichiarazione, ArrayList arrayList, String string) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException {
        this.nodoPadre = nodoAD;
        this.nome = string;
        this.altezzaNodo = nodoAD.getAltezzaNodo() + 1;
        this.esempi = exampleSet;
        this.dichiarazione = dichiarazione;
        this.nodiFigli = new ArrayList();
        this.albero = nodoAD.getAlbero();
        this.attributiDisponibili = new ArrayList(arrayList);
        this.generaFigli();
    }

    public NodoAD(AlberoDecisionale alberoDecisionale, ExampleSet exampleSet, Dichiarazione dichiarazione, int n) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException {
        this.nodoPadre = null;
        this.nome = "RADICE";
        this.altezzaNodo = n;
        this.esempi = exampleSet;
        this.dichiarazione = dichiarazione;
        this.nodiFigli = new ArrayList();
        this.attributiDisponibili = new ArrayList(this.dichiarazione.getNomeAttributi());
        this.albero = alberoDecisionale;
        this.generaFigli();
    }

    public NodoAD getFiglio(int n) {
        return (NodoAD)this.nodiFigli.get(n);
    }

    public AlberoDecisionale getAlbero() {
        return this.albero;
    }

    public String getNome() {
        return this.nome;
    }

    public ExampleSet getEsempi() {
        return this.esempi;
    }

    public ArrayList getAttributiDisponibili() {
        return this.attributiDisponibili;
    }

    public String getClassePi\u00f9Frequente() throws FileNotFoundException, ParserConfigurationException, IOException, SAXException {
        int n = 1000;
        int n2 = -1;
        ArrayList arrayList = this.albero.raggruppaEsempi(this.esempi);
        int n3 = 0;
        while (n3 < arrayList.size()) {
            ExampleSetOmogeneo exampleSetOmogeneo = (ExampleSetOmogeneo)arrayList.get(n3);
            if (n3 == 0) {
                n = exampleSetOmogeneo.getSize();
                n2 = 0;
            } else if (exampleSetOmogeneo.getSize() > n) {
                n = exampleSetOmogeneo.getSize();
                n2 = n3;
            }
            ++n3;
        }
        return ((ExampleSetOmogeneo)arrayList.get(n2)).getClasse();
    }

    public int partizionaEsempi(String string) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException {
        ExampleSet[] exampleSetArray = this.albero.applicaPartizionamento(this.esempi, string);
        ArrayList arrayList = new ArrayList(this.attributiDisponibili);
        arrayList.remove(this.nomeAttributo);
        int n = 0;
        while (n < exampleSetArray.length) {
            Object object;
            String string2 = this.dichiarazione.getTipoAttributo(string).equals("discreto") ? string + "=" + (String)this.dichiarazione.getValoriPossibiliAttributoDiscreto(string).get(n) : (n == 0 ? string + "<=" + this.dichiarazione.getSogliaAttributoContinuo(string) : string + ">" + this.dichiarazione.getSogliaAttributoContinuo(string));
            ArrayList arrayList2 = this.albero.raggruppaEsempi(exampleSetArray[n]);
            if (arrayList2.size() == 1) {
                object = ((ExampleSetOmogeneo)arrayList2.get(0)).getClasse();
                this.nodiFigli.add(new FogliaAD(this, (String)object, string2));
            } else {
                object = new NodoAD(this, exampleSetArray[n], this.dichiarazione, arrayList, string2);
                this.nodiFigli.add(object);
            }
            ++n;
        }
        return exampleSetArray.length;
    }

    public String scegliAttributo() throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException {
        String string;
        this.nomeAttributo = string = this.albero.selezionaAttributo(this);
        return string;
    }

    public int generaFigli() throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException {
        if (this.esempi.getSize() == 0) {
            String string = this.nodoPadre.getClassePi\u00f9Frequente();
            this.nodiFigli.add(new FogliaAD(this, string, "Nodo senza esempi"));
            return 1;
        }
        if (this.attributiDisponibili.size() == 0) {
            this.nodiFigli.add(new FogliaAD(this, this.getClassePi\u00f9Frequente(), "Attrbuti finiti"));
            return 1;
        }
        ArrayList arrayList = this.albero.raggruppaEsempi(this.esempi);
        if (arrayList.size() == 1) {
            String string = ((ExampleSetOmogeneo)arrayList.get(0)).getClasse();
            this.nodiFigli.add(new FogliaAD(this, string, "foglia"));
            return 1;
        }
        String string = this.scegliAttributo();
        return this.partizionaEsempi(string);
    }

    public String valuta(Istanza istanza) throws AttributeNotFoundException {
        String string = this.dichiarazione.getTipoAttributo(this.nomeAttributo);
        if (string == null) {
            return ((Nodo)this.nodiFigli.get(0)).valuta(istanza);
        }
        if (string.equals("discreto")) {
            String string2 = ((AttributoDiscreto)istanza.getAttributo(this.nomeAttributo)).getValue();
            ArrayList arrayList = this.dichiarazione.getValoriPossibiliAttributoDiscreto(this.nomeAttributo);
            int n = 0;
            while (n < arrayList.size()) {
                if (string2.equals((String)arrayList.get(n))) {
                    return ((Nodo)this.nodiFigli.get(n)).valuta(istanza);
                }
                ++n;
            }
        } else {
            int n;
            int n2 = ((AttributoContinuo)istanza.getAttributo(this.nomeAttributo)).getValue();
            if (n2 <= (n = this.dichiarazione.getSogliaAttributoContinuo(this.nomeAttributo))) {
                return ((Nodo)this.nodiFigli.get(0)).valuta(istanza);
            }
            return ((Nodo)this.nodiFigli.get(1)).valuta(istanza);
        }
        return "Errore";
    }

    public int getAltezzaNodo() {
        return this.altezzaNodo;
    }

    public String getNomeAttributo() {
        return this.nomeAttributo;
    }

    public ArrayList getPath() {
        if (this.altezzaNodo == 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.nome);
            return arrayList;
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.nodoPadre.getPath());
        arrayList.add(this.nome);
        return arrayList;
    }

    public String toString() {
        return this.nome;
    }
}

