/*
 * Decompiled with CFR 0.152.
 */
package Src.Logica;

import Src.Logica.Attributo;
import Src.Logica.AttributoContinuo;
import Src.Logica.AttributoDiscreto;
import Src.Logica.Dichiarazione;
import Src.Servizi.Exception.AttributeNotFoundException;
import Src.Servizi.ServiziXML.LibreriaDOM.LibreriaDOM;
import Src.Servizi.ServiziXML.LibreriaDOM.XMLElement;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Istanza
implements XMLElement,
Serializable {
    private ArrayList listaAttributi;
    private Dichiarazione dichiarazione;

    public Istanza() throws FileNotFoundException, ParserConfigurationException, IOException, SAXException {
        this.listaAttributi = new ArrayList();
        this.dichiarazione = new Dichiarazione();
    }

    public Istanza(ArrayList arrayList) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException {
        this.listaAttributi = arrayList;
        this.dichiarazione = new Dichiarazione();
    }

    public Istanza(Element element, Dichiarazione dichiarazione) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException {
        this.listaAttributi = new ArrayList();
        this.dichiarazione = dichiarazione;
        int n = this.dichiarazione.getNumAttributi();
        int n2 = 0;
        while (n2 < n) {
            String string = this.dichiarazione.getNomeAttributo(n2);
            String string2 = this.dichiarazione.getTipoAttributo(string);
            if (string2.equals("continuo")) {
                this.addAttributo(new AttributoContinuo(string, new Integer(LibreriaDOM.getValue(element, string))));
            } else {
                String string3 = LibreriaDOM.getValue(element, string);
                if (this.dichiarazione.checkValoreAttributo(string, string3)) {
                    this.addAttributo(new AttributoDiscreto(string, string3));
                } else {
                    System.out.println("Costruttore Istanza(el): Il valore da assegnare all'attributo discreto non \u00e8 valido: " + string3);
                }
            }
            ++n2;
        }
    }

    public ArrayList getListaAttributi() {
        return this.listaAttributi;
    }

    public Attributo getAttributo(int n) throws IndexOutOfBoundsException {
        return (Attributo)this.listaAttributi.get(n);
    }

    public Attributo getAttributo(String string) throws AttributeNotFoundException {
        int n = 0;
        while (n < this.getSize()) {
            Attributo attributo = this.getAttributo(n);
            if (attributo.getNome().equals(string)) {
                return attributo;
            }
            ++n;
        }
        throw new AttributeNotFoundException("Non esiste un attributo chiamato " + string + " nell'istanza.");
    }

    public void addAttributo(Attributo attributo) {
        this.listaAttributi.add(attributo);
    }

    public int getSize() {
        return this.listaAttributi.size();
    }

    public Element objToXml(Document document) {
        Element element = document.createElement("istanza");
        int n = 0;
        while (n < this.getSize()) {
            Attributo attributo = this.getAttributo(n);
            Element element2 = attributo.objToXml(document);
            element.appendChild(element2);
            ++n;
        }
        return element;
    }

    public XMLElement xmlToObj(Element element) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException {
        return new Istanza(element, this.dichiarazione);
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.getSize()) {
            Attributo attributo = this.getAttributo(n);
            string = attributo.getTipo().equals("continuo") ? string + "  " + ((AttributoContinuo)attributo).getValue() : string + "  " + ((AttributoDiscreto)attributo).getValue();
            ++n;
        }
        return string;
    }
}

