/*
 * Decompiled with CFR 0.152.
 */
package Src.Logica;

import Src.Logica.Istanza;
import Src.Logica.TrainingSet;
import Src.Servizi.ServiziXML.LibreriaDOM.LibreriaDOM;
import Src.Servizi.ServiziXML.LibreriaDOM.XMLElement;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Esempio
implements XMLElement,
Serializable {
    private Istanza istanza;
    private String classe;
    private TrainingSet ts;

    public Esempio(TrainingSet trainingSet, Istanza istanza, String string) {
        this.ts = trainingSet;
        this.istanza = istanza;
        this.classe = string;
    }

    public Esempio(Element element, TrainingSet trainingSet) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException {
        this.ts = trainingSet;
        NodeList nodeList = element.getElementsByTagName("class");
        this.classe = LibreriaDOM.getValue(element, "class");
        NodeList nodeList2 = element.getElementsByTagName("istanza");
        Element element2 = (Element)nodeList2.item(0);
        this.istanza = new Istanza(element2, this.ts.getDichiarazione());
    }

    public String getClasse() {
        return this.classe;
    }

    public Istanza getIstanza() {
        return this.istanza;
    }

    public Element objToXml(Document document) {
        Element element = document.createElement("esempio");
        Element element2 = this.istanza.objToXml(document);
        Element element3 = LibreriaDOM.createTextElement(document, "classe", this.classe, false);
        element.appendChild(element2);
        element.appendChild(element3);
        return element;
    }

    public XMLElement xmlToObj(Element element) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException {
        return new Esempio(element, this.ts);
    }

    public String toString() {
        return this.istanza.toString() + "     " + this.classe;
    }
}

