/*
 * Decompiled with CFR 0.152.
 */
package Src.Logica;

import Src.Logica.AlberoDecisionale;
import Src.Logica.Esempio;
import Src.Logica.ExampleSet;
import Src.Logica.Istanza;
import Src.Logica.TrainingSet;
import Src.Servizi.Exception.AttributeNotFoundException;
import Src.Servizi.Exception.ElementNotFoundException;
import Src.Servizi.ServiziXML.LibreriaDOM.DocumentHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Random;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Classificatore {
    private TrainingSet ts;
    private AlberoDecisionale albero;
    private ExampleSet testingSet;

    public TrainingSet getTrainingSet() {
        return this.ts;
    }

    public ExampleSet getTestingSet() {
        return this.testingSet;
    }

    public Classificatore(String string) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, ElementNotFoundException, AttributeNotFoundException {
        this.ts = this.caricaTrainingSet(string);
        new Classificatore(this.ts);
    }

    public Classificatore(TrainingSet trainingSet) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException {
        this.albero = new AlberoDecisionale(trainingSet);
        this.testingSet = new ExampleSet();
    }

    public TrainingSet caricaTrainingSet(String string) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, ElementNotFoundException, AttributeNotFoundException {
        if (string == null) {
            string = "c:/progetti/Classificatore/TrainingSet.xml";
        }
        DocumentHandler documentHandler = new DocumentHandler(string);
        this.ts = (TrainingSet)documentHandler.loadElementFromXML("elenco", "id", "1");
        return this.ts;
    }

    public String classifica(Istanza istanza) throws AttributeNotFoundException {
        return this.albero.valuta(istanza);
    }

    public boolean isCovered(Esempio esempio) throws AttributeNotFoundException {
        Istanza istanza = esempio.getIstanza();
        String string = this.classifica(istanza);
        return string.equals(esempio.getClasse());
    }

    public boolean isCorrect() throws AttributeNotFoundException {
        int n = 0;
        while (n < this.ts.getSize()) {
            Esempio esempio = this.ts.getEsempio(n);
            if (!this.isCovered(esempio)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void creaTestingSet(int n) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException {
        int n2;
        System.out.println("Creazione del TestingSet:");
        this.testingSet = new ExampleSet();
        Random random = new Random();
        int n3 = 0;
        while (n3 < n) {
            n2 = random.nextInt(this.ts.getSize() - 1);
            System.out.println("Prelievo dell " + n3 + "-esimo elemeto... Indice:" + n2);
            System.out.println("Dimensione attuale TrainingSet:" + this.ts.getSize());
            Esempio esempio = this.ts.removeEsempio(n2);
            this.testingSet.addEsempio(esempio);
            System.out.println("Dimensione attuale TestingSet:" + this.testingSet.getSize());
            ++n3;
        }
        this.albero = new AlberoDecisionale(this.ts);
        System.out.println("");
        System.out.println("Testing Set generato (dimensione " + n + "):");
        n2 = 0;
        while (n2 < this.testingSet.getSize()) {
            System.out.print(this.testingSet.getEsempio(n2).getIstanza() + " ");
            System.out.println(this.testingSet.getEsempio(n2).getClasse());
            ++n2;
        }
        System.out.println("");
        System.out.println("TrainingSet:");
        int n4 = 0;
        while (n4 < this.ts.getSize()) {
            System.out.print(this.ts.getEsempio(n4).getIstanza() + " ");
            System.out.println(this.ts.getEsempio(n4).getClasse());
            ++n4;
        }
    }

    public AlberoDecisionale getAlbero() {
        return this.albero;
    }

    public String valutaErroreSulTestingSet() throws AttributeNotFoundException {
        int n = 0;
        int n2 = 0;
        if (this.testingSet.getSize() == 0) {
            return "0.0%";
        }
        int n3 = 0;
        while (n3 < this.testingSet.getSize()) {
            Esempio esempio = this.testingSet.getEsempio(n3);
            Istanza istanza = esempio.getIstanza();
            String string = this.classifica(istanza);
            if (string.equals(esempio.getClasse())) {
                System.out.println("++++++++++++++OK. ESEMPIO CLASSIFICATO CORRETTAMENTE:   " + esempio);
                ++n;
            } else {
                System.out.println("---------------CLASSIFICAZIONE ERRATA: " + esempio + "\u00e8 stato classificato " + string);
                ++n2;
            }
            ++n3;
        }
        return "" + (float)n2 / ((float)n2 + (float)n) * 100.0f + "%";
    }
}

