/*
 * Decompiled with CFR 0.152.
 */
package Src.Logica;

import Src.Logica.AttributoContinuo;
import Src.Logica.AttributoDiscreto;
import Src.Logica.Dichiarazione;
import Src.Logica.Esempio;
import Src.Logica.ExampleSet;
import Src.Logica.ExampleSetOmogeneo;
import Src.Logica.FogliaAD;
import Src.Logica.Istanza;
import Src.Logica.NodoAD;
import Src.Logica.TrainingSet;
import Src.Servizi.Exception.AttributeNotFoundException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class AlberoDecisionale {
    NodoAD nodoRadice;
    TrainingSet ts;
    Dichiarazione dichiarazione;
    ArrayList nodiFoglia;

    public AlberoDecisionale(TrainingSet trainingSet) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException {
        this.ts = trainingSet;
        this.dichiarazione = trainingSet.getDichiarazione();
        this.nodiFoglia = new ArrayList();
        this.nodoRadice = new NodoAD(this, this.ts, this.dichiarazione, 0);
    }

    public ArrayList getNodiFoglia() {
        return this.nodiFoglia;
    }

    public String selezionaAttributo(NodoAD nodoAD) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException {
        ExampleSet exampleSet = nodoAD.getEsempi();
        ArrayList arrayList = nodoAD.getAttributiDisponibili();
        if (arrayList.size() == 1) {
            return (String)arrayList.get(0);
        }
        double d = this.calcolaEntropia(exampleSet);
        double[] dArray = new double[arrayList.size()];
        double d2 = -1.0;
        String string = "";
        int n = 0;
        while (n < arrayList.size()) {
            String string2 = (String)arrayList.get(n);
            ExampleSet[] exampleSetArray = this.applicaPartizionamento(exampleSet, string2);
            dArray[n] = this.calcolaEntropiaExampleSetPartizionato(exampleSetArray, string2);
            double d3 = d - dArray[n];
            if (d3 > d2) {
                d2 = d3;
                string = string2;
            }
            ++n;
        }
        return string;
    }

    public ExampleSet[] applicaPartizionamento(ExampleSet exampleSet, String string) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException {
        ExampleSet[] exampleSetArray;
        String string2 = this.dichiarazione.getTipoAttributo(string);
        if (string2.equals("discreto")) {
            ArrayList arrayList = this.dichiarazione.getValoriPossibiliAttributoDiscreto(string);
            exampleSetArray = new ExampleSet[arrayList.size()];
            int n = 0;
            while (n < exampleSetArray.length) {
                exampleSetArray[n] = new ExampleSet();
                ++n;
            }
            int n2 = 0;
            while (n2 < exampleSet.getSize()) {
                Esempio esempio = exampleSet.getEsempio(n2);
                String string3 = ((AttributoDiscreto)esempio.getIstanza().getAttributo(string)).getValue();
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    if (string3.equals((String)arrayList.get(n3))) {
                        exampleSetArray[n3].addEsempio(esempio);
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
        } else {
            exampleSetArray = new ExampleSet[2];
            int n = 0;
            while (n < 2) {
                exampleSetArray[n] = new ExampleSet();
                ++n;
            }
            int n4 = this.dichiarazione.getSogliaAttributoContinuo(string);
            int n5 = 0;
            while (n5 < exampleSet.getSize()) {
                Esempio esempio = exampleSet.getEsempio(n5);
                int n6 = ((AttributoContinuo)esempio.getIstanza().getAttributo(string)).getValue();
                if (n6 <= n4) {
                    exampleSetArray[0].addEsempio(esempio);
                } else {
                    exampleSetArray[1].addEsempio(esempio);
                }
                ++n5;
            }
        }
        return exampleSetArray;
    }

    public double calcolaEntropiaExampleSetPartizionato(ExampleSet[] exampleSetArray, String string) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException, AttributeNotFoundException {
        double d;
        int n;
        String string2 = this.dichiarazione.getTipoAttributo(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("inf");
        arrayList.add("sup");
        ArrayList arrayList2 = string2.equals("discreto") ? new ArrayList(this.dichiarazione.getValoriPossibiliAttributoDiscreto(string)) : new ArrayList(arrayList);
        double[] dArray = new double[arrayList2.size()];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = 0.0;
            ++n2;
        }
        int n3 = 0;
        while (n3 < arrayList2.size()) {
            String string3 = (String)arrayList2.get(n3);
            ExampleSet exampleSet = exampleSetArray[n3];
            int[] nArray = new int[this.dichiarazione.getNumClassi()];
            int n4 = 0;
            while (n4 < nArray.length) {
                nArray[n4] = 0;
                ++n4;
            }
            ArrayList arrayList3 = this.dichiarazione.getNomeClassi();
            n = 0;
            while (n < exampleSet.getSize()) {
                int n5;
                int n6;
                Esempio esempio = exampleSet.getEsempio(n);
                String string4 = string2.equals("discreto") ? ((AttributoDiscreto)esempio.getIstanza().getAttributo(string)).getValue() : ((n6 = new Integer(((AttributoContinuo)esempio.getIstanza().getAttributo(string)).getValue()).intValue()) <= (n5 = this.dichiarazione.getSogliaAttributoContinuo(string)) ? "inf" : "sup");
                n6 = 0;
                while (n6 < arrayList3.size()) {
                    String string5 = (String)this.dichiarazione.getNomeClassi().get(n6);
                    if (esempio.getClasse().equals(string5)) {
                        int n7 = n6;
                        nArray[n7] = nArray[n7] + 1;
                        break;
                    }
                    ++n6;
                }
                ++n;
            }
            dArray[n3] = d = this.calcolaEntropia(exampleSet);
            ++n3;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        int n8 = 0;
        while (n8 < exampleSetArray.length) {
            d3 += (double)exampleSetArray[n8].getSize();
            ++n8;
        }
        n = 0;
        while (n < exampleSetArray.length) {
            d = (double)exampleSetArray[n].getSize() / d3;
            d2 += (double)exampleSetArray[n].getSize() / d3 * dArray[n];
            ++n;
        }
        return d2;
    }

    public ArrayList raggruppaEsempi(ExampleSet exampleSet) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException {
        int[] nArray = new int[this.dichiarazione.getNumClassi()];
        boolean[] blArray = new boolean[this.dichiarazione.getNumClassi()];
        int n = 0;
        while (n < blArray.length) {
            blArray[n] = false;
            ++n;
        }
        int n2 = 0;
        while (n2 < blArray.length) {
            nArray[n2] = 0;
            ++n2;
        }
        ArrayList<ExampleSetOmogeneo> arrayList = new ArrayList<ExampleSetOmogeneo>();
        int n3 = 0;
        while (n3 < exampleSet.getSize()) {
            ExampleSetOmogeneo exampleSetOmogeneo;
            Esempio esempio = exampleSet.getEsempio(n3);
            String string = esempio.getClasse();
            int n4 = 0;
            while (n4 < arrayList.size()) {
                exampleSetOmogeneo = (ExampleSetOmogeneo)arrayList.get(n4);
                if (exampleSetOmogeneo.getClasse().equals(string)) {
                    exampleSetOmogeneo.addEsempio(esempio);
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + 1;
                    break;
                }
                ++n4;
            }
            if (!blArray[n4]) {
                exampleSetOmogeneo = new ExampleSetOmogeneo(string);
                exampleSetOmogeneo.addEsempio(esempio);
                arrayList.add(exampleSetOmogeneo);
                int n6 = arrayList.lastIndexOf(exampleSetOmogeneo);
                nArray[n6] = nArray[n6] + 1;
                blArray[n4] = true;
            }
            ++n3;
        }
        return arrayList;
    }

    public double calcolaEntropia(ExampleSet exampleSet) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException {
        ArrayList arrayList = this.raggruppaEsempi(exampleSet);
        double[] dArray = new double[arrayList.size()];
        int n = exampleSet.getSize();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            ExampleSetOmogeneo exampleSetOmogeneo = (ExampleSetOmogeneo)arrayList.get(n2);
            dArray[n2] = (double)exampleSetOmogeneo.getSize() / (double)n;
            ++n2;
        }
        double d = 0.0;
        int n3 = 0;
        while (n3 < arrayList.size()) {
            d += -1.0 * dArray[n3] * Math.log(dArray[n3]) / Math.log(2.0);
            ++n3;
        }
        return d;
    }

    public void addNodoFoglia(FogliaAD fogliaAD) {
        this.nodiFoglia.add(fogliaAD);
    }

    public String valuta(Istanza istanza) throws AttributeNotFoundException {
        return this.nodoRadice.valuta(istanza);
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.nodiFoglia.size()) {
            string = string + ((FogliaAD)this.nodiFoglia.get(n)).toString() + "\n";
            ++n;
        }
        return string;
    }
}

