/*
 * Created on 3-lug-2004
 */
package jaCop.protocol;

import java.util.*;

import jaCop.domain.*;

/**
 * @author Lompa
 */
public class TaskConversersList {
	
	private Vector tasksConversers = new Vector();
	
	public TaskConversersList() {
	}
	
	public void addRegistration(COPTask client, COPNode servant, String community){
		boolean exists = false;
		for(int i = 0; i < tasksConversers.size(); i++){
			TaskConvDescriptor desc = (TaskConvDescriptor) tasksConversers.get(i);
			if (desc.task == client && desc.servant.isSame(servant)) exists = true;
		}
		if (!exists){
			TaskConvDescriptor desc = new TaskConvDescriptor(client, servant, community);
			tasksConversers.add(desc);
		}
		//jaCop.Debug.print("\nCLIENT AGGIUNTO: "+desc.task.getConv().encode());
	}
	
	public void clearClient(COPTask task){
		for(int i = 0; i < tasksConversers.size(); i++){
			if (((TaskConvDescriptor) tasksConversers.get(i)).task == task)
				tasksConversers.remove(i);
		}
	}

	public int interruptClientFor(String community, COPNode node){
		int interruptedClients = 0;
		for(int i = 0; i < tasksConversers.size(); i++){
			TaskConvDescriptor desc = (TaskConvDescriptor) tasksConversers.get(i);
			if (desc.community.equals(community) && desc.servant.isSame(node)){
				desc.task.interrupt();
				//jaCop.Debug.print("\nCLIENT INTERROTTO: "+desc.task.getConv().encode());
				interruptedClients++;
			}
		}
		return interruptedClients;
	}
	
	private static class TaskConvDescriptor {
		
		private COPTask task = null;
		private COPNode servant = null;
		private String community = null;
		
		/**
		 * @param task
		 * @param servant
		 */
		private  TaskConvDescriptor(COPTask task, COPNode servant, String community) {
			this.task = task;
			this.servant = servant;
			this.community = community;
		}
	}
	
}
