/*
 * Created on 8-mag-2004
 */
package jaCop.protocol;

import convFramework.domain.Node;
import convFramework.traffic.event.MissingAckEvent;
import convFramework.traffic.event.NewConversationEvent;
import jaCop.domain.COPNode;
import jaCop.event.ICommunityJoinedListener;
import jaCop.event.ICommunityLeftListener;
import jaCop.event.IJoinRequestRefusedListener;
import jaCop.event.INewJunctureListener;
import jaCop.event.INeighborLostListener;
import jaCop.event.INewNeighborListener;
import jaCop.nodeStatus.*;

/**
 * @author Lompa
 */
public class ProtocolManager {
	
	/* campi */
	private ProtocolTrigger trigger = null;
	private COPEventListenerManager listenerMan = null;
	private StatusStore statusStore = null; 
	
	/**
	 * @param trigger
	 * @param listenerMan
	 * @param statusStore
	 */
	public ProtocolManager(ProtocolTrigger trigger,
			COPEventListenerManager listenerMan, StatusStore statusStore) {
		this.trigger = trigger;
		this.listenerMan = listenerMan;
		this.statusStore = statusStore;
	}
	
	/* metodi per conoscere lo stato del sistema *********************************************************/
	/**
	 * @param community
	 * @return
	 */
	public boolean existsCommunity(String community) {
		return statusStore.existsCommunity(community);
	}
	/**
	 * @param community
	 * @return
	 */
	public COPNode[] getNeighbors(String community) {
		return statusStore.getNeighbors(community);
	}
	/**
	 * @param community
	 * @return
	 */
	public COPNode[] getStructureNeighbors(String community) {
		return statusStore.getStructureNeighbors(community);
	}
	
	public COPNode[] getJoinedNeighbors(String community) {
		return statusStore.getJoinedNeighbors(community);
	}
	/**
	 * @param community
	 * @param node
	 * @return
	 */
	public COPNode[] getStructureNeighbors(String community, COPNode node) {
		return statusStore.getStructureNeighbors(community, node);
	}
	/**
	 * @param community
	 * @return
	 */
	public COPNode getCurrentNode(String community) {
		return statusStore.getCurrentNode(community);
	}
	/**
	 * @param community
	 * @return
	 */
	public COPNode getJuncturePoint(String community) {
		return statusStore.getJuncturePoint(community);
	}
	/**
	 * @param community
	 * @param node
	 * @return
	 */
	public boolean isJoined(String community, COPNode node) {
		return statusStore.isJoined(community, node);
	}
	/**
	 * @param community
	 * @param node
	 * @return
	 */
	public boolean isNeighbor(String community, COPNode node) {
		return statusStore.isNeighbor(community, node);
	}
	/**
	 * @return
	 */
	public String[] getCommunities() {
		return statusStore.getCommunities();
	}
	
	/* metodi per la registrazione di ascoltatori *********************************************************/
	/**
	 * @param listener
	 */
	public void addCommunityJoinedListener(ICommunityJoinedListener listener) {
		listenerMan.addCommunityJoinedListener(listener);
	}
	/**
	 * @param listener
	 */
	public void addCommunityLeftListener(ICommunityLeftListener listener) {
		listenerMan.addCommunityLeftListener(listener);
	}
	/**
	 * @param listener
	 */
	public void addJoinRequestRefusedListener(
			IJoinRequestRefusedListener listener) {
		listenerMan.addJoinRequestRefusedListener(listener);
	}
	/**
	 * @param listener
	 */
	public void addNeighborLostListener(INeighborLostListener listener) {
		listenerMan.addNeighborLostListener(listener);
	}
	/**
	 * @param listener
	 */
	public void addNewNeighborListener(INewNeighborListener listener) {
		listenerMan.addNewNeighborListener(listener);
	}
	/**
	 * @param listener
	 */
	public void removeCommunityJoinedListener(ICommunityJoinedListener listener) {
		listenerMan.removeCommunityJoinedListener(listener);
	}
	/**
	 * @param listener
	 */
	public void removeCommunityLeftListener(ICommunityLeftListener listener) {
		listenerMan.removeCommunityLeftListener(listener);
	}
	/**
	 * @param listener
	 */
	public void removeJoinRequestRefusedListener(
			IJoinRequestRefusedListener listener) {
		listenerMan.removeJoinRequestRefusedListener(listener);
	}
	/**
	 * @param listener
	 */
	public void removeNeighborLostListener(INeighborLostListener listener) {
		listenerMan.removeNeighborLostListener(listener);
	}
	/**
	 * @param listener
	 */
	public void removeNewNeighborListener(INewNeighborListener listener) {
		listenerMan.removeNewNeighborListener(listener);
	}
	
	/* metodi per innescare delle azioni di protocolo *******************************************************/
	
	/**
	 * @param community
	 * @param servant
	 * @param nodeCapacity
	 * @param maxDelegationsNumber
	 */
	public void joinCommunity(String community, Node server, ILoadFactorCalculator calc, int maxDelegations) {
		trigger.joinCommunity(community, server, calc, maxDelegations);
	}
	/**
	 * @param community
	 */
	public void leaveCommunity(String community) {
		trigger.leaveCommunity(community);
	}
	/**
	 * @param community
	 * @param calc
	 */
	public void openCommunity(String community, ILoadFactorCalculator calc, int connectionRank) {
		trigger.openCommunity(community, calc, connectionRank);
	}
	/**
	 * @param listener
	 */
	public void addNewJunctureListener(INewJunctureListener listener) {
		listenerMan.addJunctureChangedListener(listener);
	}
	/**
	 * @param listener
	 */
	public void removeJunctureChangedListener(INewJunctureListener listener) {
		listenerMan.removeJunctureChangedListener(listener);
	}
	/**
	 * @param event
	 */
	public void missingAck(MissingAckEvent event) {
		trigger.missingAck(event);
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return trigger.hashCode();
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return trigger.toString();
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object arg0) {
		return trigger.equals(arg0);
	}
	/**
	 * @param event
	 */
	public void newConversationStarted(NewConversationEvent event) {
		trigger.newConversationStarted(event);
	}
	/**
	 * @param community
	 * @return
	 */
	public int getConnectionRank(String community) {
		return statusStore.getConnectionRank(community);
	}
}
