/*
 * Created on 20-apr-2004
 */
package jaCop.protocol;

import java.util.*;

import jaCop.event.*;
import jaCop.exceptions.*;

/**
 * Gestore cui occorre registrare i listener degli eventi legati all'arrivo di pacchetti,
 * perch possnao esserne notificati. Ne pu esistere una sola istanza. La classe  predisposta per supportare
 * accessi concorrenti
 * @author Lompa
 */
public class COPEventListenerManager {
	
	/* flag di istanziazione */
	//private static boolean instantiated = false;
	
	/* campi */
	private Vector communityJoinedListeners = new Vector();
	private Vector communityLeftListeners = new Vector();
	private Vector joinRequestRefusedListeners = new Vector();
	private Vector newNeighborListeners = new Vector();
	private Vector neighborLostListeners = new Vector();
	private Vector junctureChangedListeners = new Vector();
	
	/**
	 * Crea un istanza di A3EventListenerManager
	 * @throws InstantiationRuleBrokenException se la classe  gi stata istanziata
	 */
	public COPEventListenerManager() throws InstantiationRuleBrokenException{
		//if (instantiated)
		//	throw new InstantiationRuleBrokenException("Cannot create more than one A3EventListenerManager");
		
		//instantiated = true;
	}
	
	public synchronized void addCommunityJoinedListener(ICommunityJoinedListener listener){
		this.communityJoinedListeners.add(listener);
	}
	
	public synchronized void removeCommunityJoinedListener(ICommunityJoinedListener listener){
		this.communityJoinedListeners.remove(listener);
	}
	
	public synchronized void addCommunityLeftListener(ICommunityLeftListener listener){
		this.communityLeftListeners.add(listener);
	}
	
	public synchronized void removeCommunityLeftListener(ICommunityLeftListener listener){
		this.communityLeftListeners.remove(listener);
	}
	
	public synchronized void addJoinRequestRefusedListener(IJoinRequestRefusedListener listener){
		this.joinRequestRefusedListeners.add(listener);
	}
	
	public synchronized void removeJoinRequestRefusedListener(IJoinRequestRefusedListener listener){
		this.joinRequestRefusedListeners.remove(listener);
	}
	
	public synchronized void addNewNeighborListener(INewNeighborListener listener){
		this.newNeighborListeners.add(listener);
	}
	
	public synchronized void removeNewNeighborListener(INewNeighborListener listener){
		this.newNeighborListeners.remove(listener);
	}
	
	public synchronized void addNeighborLostListener(INeighborLostListener listener){
		this.neighborLostListeners.add(listener);
	}
	
	public synchronized void removeNeighborLostListener(INeighborLostListener listener){
		this.neighborLostListeners.remove(listener);
	}
	
	public synchronized void addJunctureChangedListener(INewJunctureListener listener){
		this.junctureChangedListeners.add(listener);
	}
	
	public synchronized void removeJunctureChangedListener(INewJunctureListener listener){
		this.junctureChangedListeners.remove(listener);
	}
	
	public synchronized ICommunityJoinedListener[] getCommunityJoinedListeners(){
		ICommunityJoinedListener[] listeners = new ICommunityJoinedListener[this.communityJoinedListeners.size()];
		this.communityJoinedListeners.toArray(listeners);
		return listeners;
	}
	
	public synchronized ICommunityLeftListener[] getCommunityLeftListeners(){
		ICommunityLeftListener[] listeners = new ICommunityLeftListener[this.communityLeftListeners.size()];
		this.communityLeftListeners.toArray(listeners);
		return listeners;
	}
	
	public synchronized IJoinRequestRefusedListener[] getJoinRequestRefusedListeners(){
		IJoinRequestRefusedListener[] listeners = new IJoinRequestRefusedListener[this.joinRequestRefusedListeners.size()];
		this.joinRequestRefusedListeners.toArray(listeners);
		return listeners;
	}	
	
	public synchronized INewNeighborListener[] getNewNeighborListeners(){
		INewNeighborListener[] listeners = new INewNeighborListener[this.newNeighborListeners.size()];
		this.newNeighborListeners.toArray(listeners);
		return listeners;
	}
	
	public synchronized INeighborLostListener[] getNeighborLostListeners(){
		INeighborLostListener[] listeners = new INeighborLostListener[this.neighborLostListeners.size()];
		this.neighborLostListeners.toArray(listeners);
		return listeners;
	}
	
	public synchronized INewJunctureListener[] getJunctureChangedListeners(){
		INewJunctureListener[] listeners = new INewJunctureListener[this.junctureChangedListeners.size()];
		this.junctureChangedListeners.toArray(listeners);
		return listeners;
	}
	
}
