/*
 * Created on 26-apr-2004
 */
package jaCop.domain;

import convFramework.domain.IConversationID;
import convFramework.domain.IPacketID;

/**
 * @author Lompa
 */
public class NewNeighbor extends COPPacket {
	
	private COPNode[] neighborStructure = null;
	private COPNode neighbor = null;
	
	/**
	 * @param community
	 * @param sender
	 * @param convID
	 * @param packetID
	 */
	public NewNeighbor(String community, COPNode sender,
			IConversationID convID, IPacketID packetID) {
		super(community, sender, convID, packetID);
	}
	/**
	 * @return Returns the neighborStructure.
	 */
	public COPNode[] getNeighborStructure() {
		return neighborStructure;
	}
	/**
	 * @param neighborStructure The neighborStructure to set.
	 */
	public void setNeighborStructure(COPNode[] neighbors) {
		this.neighborStructure = neighbors;
	}
	/* (non-Javadoc)
	 * @see jaCop.domain.A3Packet#getType()
	 */
	public String getType() {
		return getTypeDescription();
	}
	
	/* (non-Javadoc)
	 * @see jaCop.domain.A3Packet#getTypeDescription()
	 */
	public static String getTypeDescription(){
		return "newNeighbors";
	}
	/**
	 * @return Returns the neighbor.
	 */
	public COPNode getNeighbor() {
		return neighbor;
	}
	/**
	 * @param neighbor The neighbor to set.
	 */
	public void setNeighbor(COPNode neighbor) {
		this.neighbor = neighbor;
	}
}
