/*
 * Created on 26-apr-2004
 */
package jaCop.domain;

import convFramework.domain.IConversationID;
import convFramework.domain.IPacketID;

/**
 * @author Lompa
 */
public class JoinRequest extends COPPacket{
	
	private COPNode requester = null;
	private COPNode[] requesterStructureNeighbors = null;
	private boolean force = false;
	
	/**
	 * @param community
	 * @param sender
	 * @param convID
	 * @param packetID
	 */
	public JoinRequest(String community, COPNode sender,
			IConversationID convID, IPacketID packetID) {
		super(community, sender, convID, packetID);
	}
	/**
	 * @return Returns the requester.
	 */
	public COPNode getRequester() {
		return requester;
	}
	/**
	 * @param requester The requester to set.
	 */
	public void setRequester(COPNode requester) {
		this.requester = requester;
	}
	/**
	 * @return Returns the requesterStructureNeighbors.
	 */
	public COPNode[] getRequesterStructureNeighbors() {
		return requesterStructureNeighbors;
	}
	/**
	 * @param requesterStructureNeighbors The requesterStructureNeighbors to set.
	 */
	public void setRequesterStructureNeighbors(COPNode[] requesterNeighbors) {
		this.requesterStructureNeighbors = requesterNeighbors;
	}
	
	/* (non-Javadoc)
	 * @see jaCop.domain.A3Packet#getType()
	 */
	public String getType() {
		return getTypeDescription();
	}
	
	/* (non-Javadoc)
	 * @see jaCop.domain.A3Packet#getTypeDescription()
	 */
	public static String getTypeDescription(){
		return "joinRequest";
	}
	/**
	 * @return Returns the force.
	 */
	public boolean force() {
		return force;
	}
	/**
	 * @param force The force to set.
	 */
	public void setForce(boolean force) {
		this.force = force;
	}
}
