/*
 * Created on 27-apr-2004
 */
package jaCop.domain;

import convFramework.domain.IConversationID;
import convFramework.domain.IPacketID;

/**
 * @author Lompa
 */
public class Heartbeat extends COPPacket {
	
	private IPacketID acksTo = null;
	private boolean ackRequired = true;
	
	/**
	 * @param community
	 * @param sender
	 * @param convID
	 * @param packetID
	 */
	public Heartbeat(String community, COPNode sender,
			IConversationID convID, IPacketID packetID) {
		super(community, sender, convID, packetID);
	}
	
	public void acksTo(IPacketID packetID){
		this.acksTo = packetID;
		this.ackRequired = false;
	}
	
	public IPacketID getAckedPacket(){
		return this.acksTo;
	}

	/* (non-Javadoc)
	 * @see jaCop.domain.A3Packet#getType()
	 */
	public String getType() {
		return getTypeDescription();
	}
	
	/* (non-Javadoc)
	 * @see jaCop.domain.A3Packet#getTypeDescription()
	 */
	public static String getTypeDescription(){
		return "heartbeat";
	}
	/**
	 * @return Returns the ackRequired.
	 */
	public boolean isAckRequired() {
		return ackRequired;
	}
	/**
	 * @param ackRequired The ackRequired to set.
	 */
	public void setAckRequired() {
		this.ackRequired = true;
		this.acksTo = null;
	}
}
