/*
 * Created on 26-apr-2004
 */
package jaCop.domain;

import convFramework.domain.*;

/**
 * Un pacchetto per il protocollo COP
 * @author Lompa
 */
public class COPPacket {
	
	private String community = null;
	private COPNode sender = null;
	private COPNode receiver = null;
	private IConversationID convID = null;
	private boolean hasFollowing = false;
	private IPacketID previousPacket = null;
	private IPacketID packetID = null;
	
	/**
	 * @param community
	 * @param sender
	 * @param convID
	 * @param packetID
	 */
	public COPPacket(String community, COPNode sender, IConversationID convID, IPacketID packetID) {
		this.community = community;
		this.sender = sender;
		this.convID = convID;
		this.packetID = packetID;
	}	
	
	/**
	 * @return Returns the isSequence.
	 */
	public boolean isSequence() {
		return this.hasFollowing || this.previousPacket != null;
	}
	/**
	 * @return Returns the servant.
	 */
	public COPNode getReceiver() {
		return receiver;
	}
	/**
	 * @param servant The servant to set.
	 */
	public void setReceiver(COPNode receiver) {
		this.receiver = receiver;
	}
	/**
	 * @return Returns the community.
	 */
	public String getCommunity() {
		return community;
	}
	/**
	 * @return Returns the convID.
	 */
	public IConversationID getConvID() {
		return convID;
	}
	/**
	 * @return Returns the packetID.
	 */
	public IPacketID getPacketID() {
		return packetID;
	}
	/**
	 * @return Returns the sender.
	 */
	public COPNode getSender() {
		return sender;
	}
	
	/**
	 * @param packet
	 */
	public void follows(IPacketID packetID){
		this.previousPacket = packetID;
	}
	/**
	 * @return Returns the previousPacket.
	 */
	public IPacketID getPreviousPacket() {
		return previousPacket;
	}
	/**
	 * @return
	 */
	public boolean hasFollowing(){
		return this.hasFollowing;
	}
	/**
	 * @param value
	 */
	public void setFollowed(boolean value){
		this.hasFollowing = value;
	}
	/**
	 * @return
	 */
	public static String getTypeDescription(){
		return "A3Packet";
	}
	/**
	 * @return
	 */
	public String getType(){
		return getTypeDescription();
	}
}
