/*
 * Created on 20-apr-2004
 */
package convFramework.traffic.event;

import convFramework.domain.*;

/**
 * Classe che modella un evento di trasmissione di un pacchetto: viene sollevato ogni volta che un pacchetto viene
 * trasmesso "con successo" (il che significa che se un pacchetto attende una risposta l'evento di trasmissione
 * viene sollevato all'arrivo della risposta)
 * @author Lompa
 */
public class PacketTransmittedEvent extends PacketTransmissionEvent {
	
	/**
	 * Crea una istzan di PacketTransmittedEvent
	 * @param source la sorgente dell'evento
	 * @param transmittedPacket il pacchetto trasmesso
	 */
	public PacketTransmittedEvent(Object source, Packet transmittedPacket){
		super(source, transmittedPacket);
	}
	
}
